/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.orientdb;

import com.castsoftware.sca.scar.server.autoconfiguration.component.application.NoDestroyLauncher;
import com.castsoftware.sca.scar.server.orientdb.EmbeddedServer;
import com.castsoftware.sca.scar.server.orientdb.configuration.EmbeddedServerConfiguration;
import com.castsoftware.sca.scar.server.orientdb.configuration.StudioConfiguration;
import com.castsoftware.sca.scar.server.util.SystemBrowsers;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.Opt;
import com.castsoftware.sca.util.java.exception.IllegalConfigurationException;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.network.protocol.http.ONetworkProtocolHttpDb;
import jakarta.annotation.Priority;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;

@Priority(value=100)
public class StudioLauncher
extends NoDestroyLauncher {
    private final EmbeddedServer server;
    private final EmbeddedServerConfiguration configuration;

    public StudioLauncher(EmbeddedServer server, EmbeddedServerConfiguration configuration) {
        this.server = (EmbeddedServer)Guards.notNull((Object)server, IllegalConfigurationException::new);
        this.configuration = (EmbeddedServerConfiguration)Guards.notNull((Object)configuration, IllegalConfigurationException::new);
    }

    public void launch() {
        Opt.of((Object)this.configuration).map(EmbeddedServerConfiguration::getStudio).filter(StudioConfiguration::isOpenBrowser).map(c -> this.buildURL()).ifPresent(arg_0 -> this.open(arg_0));
    }

    protected void open(String url) {
        Opt.ofBlankString((String)url).ifPresent(SystemBrowsers::open);
    }

    private String buildURL() {
        AtomicReference<String> httpAddress = new AtomicReference<String>("localhost:2480");
        Opt.of((Object)this.server).map(EmbeddedServer::getServer).map(OServer::getNetworkListeners).orElseGet(ArrayList::new).forEach(listener -> {
            if (listener.getProtocolType().getName().equals(ONetworkProtocolHttpDb.class.getName())) {
                httpAddress.set(listener.getListeningAddress(true));
            }
        });
        return String.format("http://%s/studio/index.html", httpAddress.get());
    }
}

