/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.orientdb;

import com.castsoftware.sca.scar.server.orientdb.EmbeddedServer;
import com.castsoftware.sca.scar.server.orientdb.RemoteDatabasePoolBuilder;
import com.castsoftware.sca.scar.server.orientdb.configuration.RemoteDatabase;
import com.castsoftware.sca.scar.server.orientdb.configuration.UserConfiguration;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.Suppliers;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

public class RemoteDatabasePoolBuilder {
    private final RemoteDatabase remoteDatabase;
    private final DatabasePoolFactory databasePoolFactory;

    public RemoteDatabasePoolBuilder(RemoteDatabase remoteDatabase, DatabasePoolFactory databasePoolFactory) {
        this.remoteDatabase = Optional.ofNullable(remoteDatabase).filter(rdb -> rdb.getUser() != null).filter(rdb -> StringUtils.isNotBlank((CharSequence)rdb.getName())).filter(rdb -> StringUtils.isNotBlank((CharSequence)rdb.getHostname())).orElseThrow(Suppliers.illegalArgument((String)"Remote database with user is mandatory"));
        this.databasePoolFactory = (DatabasePoolFactory)Guards.notNull((Object)databasePoolFactory, (Supplier)Suppliers.illegalArgument((String)"Database pool factory is mandatory"));
    }

    public ODatabasePool build(EmbeddedServer server) {
        return this.build(this.remoteDatabase.getUser(), server);
    }

    public ODatabasePool build(UserConfiguration user, EmbeddedServer server) {
        Guards.notNull((Object)user, (Supplier)Suppliers.illegalArgument((String)"Database user configuration is mandatory"));
        Guards.notNull((Object)server, (Supplier)Suppliers.illegalArgument((String)"Embedded server is mandatory"));
        String port = Optional.of(this.remoteDatabase).map(RemoteDatabase::getPort).map(String::valueOf).orElse("2424");
        String baseUrl = String.join((CharSequence)":", "remote", this.remoteDatabase.getHostname(), port);
        return this.databasePoolFactory.create(baseUrl, this.remoteDatabase.getName(), user.getLogin(), user.getPassword(), OrientDBConfig.builder().build());
    }

    public RemoteDatabase getDatabase() {
        return this.remoteDatabase;
    }
}

