/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.orientdb;

import com.castsoftware.sca.scar.server.autoconfiguration.component.application.SCArApplication;
import com.castsoftware.sca.scar.server.orientdb.configuration.Database;
import com.castsoftware.sca.scar.server.orientdb.configuration.UserConfiguration;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.Predicates;
import com.castsoftware.sca.util.java.Suppliers;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerConfiguration;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkListenerConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkProtocolConfiguration;
import com.orientechnologies.orient.server.config.OServerStorageConfiguration;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public class EmbeddedServer {
    public static final Path DEFAULT_HOME_DIRECTORY = ((Path)SCArApplication.defaultResourceLocation(Function.identity())).resolve("orientdb");
    private final Path storage;
    private final OServer server;
    private final List<OServerUserConfiguration> users = new ArrayList();
    private final List<OServerStorageConfiguration> storages = new ArrayList();
    private final List<OServerNetworkProtocolConfiguration> protocols = new ArrayList();
    private final List<OServerNetworkListenerConfiguration> listeners = new ArrayList();
    private final List<OServerEntryConfiguration> properties = new ArrayList();

    public EmbeddedServer(OServer server, Path storage) {
        this.server = (OServer)Guards.notNull((Object)server, (Supplier)Suppliers.illegalArgument((String)"must set OServer"));
        this.storage = Objects.requireNonNullElse(storage, DEFAULT_HOME_DIRECTORY);
    }

    public OServer getServer() {
        return this.server;
    }

    public List<OServerUserConfiguration> getUsers() {
        return Collections.unmodifiableList(this.users);
    }

    public List<OServerStorageConfiguration> getStorages() {
        return Collections.unmodifiableList(this.storages);
    }

    public List<OServerNetworkProtocolConfiguration> getProtocols() {
        return Collections.unmodifiableList(this.protocols);
    }

    public List<OServerNetworkListenerConfiguration> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public List<OServerEntryConfiguration> getProperties() {
        return this.properties;
    }

    public EmbeddedServer addUser(String name, String password, String resource) {
        Optional<String> oPassword = Optional.ofNullable(password).filter(Predicates.notEmptyString());
        Optional<String> oResource = Optional.ofNullable(resource).filter(Predicates.notEmptyString());
        Optional.ofNullable(name).filter(Predicates.notEmptyString()).filter(n -> oPassword.isPresent() && oResource.isPresent()).map(n -> new OServerUserConfiguration(n, (String)oPassword.get(), (String)oResource.get())).ifPresent(this.users::add);
        return this;
    }

    public EmbeddedServer addStorage(String defaultPath, Optional<Database> database) {
        this.storages.add(this.create(defaultPath, database));
        return this;
    }

    public EmbeddedServer addProperty(String name, String value) {
        Optional<String> oValue = Optional.ofNullable(value).filter(Predicates.notEmptyString());
        Optional.ofNullable(name).filter(Predicates.notEmptyString()).filter(n -> oValue.isPresent()).map(n -> new OServerEntryConfiguration(n, (String)oValue.get())).ifPresent(this.properties::add);
        return this;
    }

    public EmbeddedServer addNetwork(OServerNetworkProtocolConfiguration protocolConfiguration, OServerNetworkListenerConfiguration listener) {
        Optional<OServerNetworkProtocolConfiguration> oProtocol = Optional.ofNullable(protocolConfiguration);
        Optional<OServerNetworkListenerConfiguration> oListener = Optional.ofNullable(listener);
        oProtocol.filter(p -> oListener.isPresent()).ifPresent(this.protocols::add);
        oListener.filter(l -> oProtocol.isPresent()).ifPresent(this.listeners::add);
        return this;
    }

    public void start() throws NoSuchMethodException, IOException, InvocationTargetException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (!this.server.isActive()) {
            OServerConfiguration configuration = new OServerConfiguration();
            configuration.users = (OServerUserConfiguration[])this.users.toArray(OServerUserConfiguration[]::new);
            configuration.storages = (OServerStorageConfiguration[])this.storages.toArray(OServerStorageConfiguration[]::new);
            configuration.network = new OServerNetworkConfiguration();
            configuration.network.protocols = new ArrayList(this.protocols);
            configuration.network.listeners = new ArrayList(this.listeners);
            configuration.properties = (OServerEntryConfiguration[])this.properties.toArray(OServerEntryConfiguration[]::new);
            this.server.startup(configuration);
            this.server.activate();
        }
    }

    @PreDestroy
    public void destroy() throws Exception {
        Optional.of(this.server).filter(OServer::isActive).ifPresent(oServer -> {
            oServer.getContext().close();
            oServer.shutdown();
        });
    }

    private OServerStorageConfiguration create(String defaultPath, Optional<Database> database) {
        String storage;
        OServerStorageConfiguration databaseStorage = new OServerStorageConfiguration();
        databaseStorage.name = storage = database.map(Database::getName).orElse(defaultPath);
        databaseStorage.path = "plocal".concat(":").concat(this.storage.toString().concat("/databases/").concat(storage).concat("/data"));
        databaseStorage.userName = database.map(Database::getUser).map(UserConfiguration::getLogin).orElseThrow(Suppliers.illegalConfiguration((String)"invalid user name"));
        databaseStorage.userPassword = database.map(Database::getUser).map(UserConfiguration::getPassword).orElseThrow(Suppliers.illegalConfiguration((String)"invalid user password"));
        databaseStorage.loadOnStartup = true;
        return databaseStorage;
    }
}

