/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.nvd.requester;

import com.castsoftware.sca.scar.server.nvd.configuration.NvdClientConfiguration;
import com.castsoftware.sca.scar.server.nvd.domain.CveApiJson20;
import com.castsoftware.sca.scar.server.nvd.domain.CveItem;
import com.castsoftware.sca.scar.server.nvd.domain.CvssV2;
import com.castsoftware.sca.scar.server.nvd.domain.CvssV30;
import com.castsoftware.sca.scar.server.nvd.domain.CvssV31;
import com.castsoftware.sca.scar.server.nvd.domain.DefCveItem;
import com.castsoftware.sca.scar.server.nvd.domain.LangString;
import com.castsoftware.sca.scar.server.nvd.domain.Metrics;
import com.castsoftware.sca.scar.server.nvd.domain.Reference;
import com.castsoftware.sca.scar.server.nvd.domain.Weakness;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityLevel;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityType;
import com.castsoftware.sca.scar.server.vulnerability.dto.DetailedVulnerabilityView;
import com.castsoftware.sca.scar.server.vulnerability.dto.ScoreView;
import com.castsoftware.sca.scar.server.vulnerability.handler.SeverityComputer;
import com.castsoftware.sca.util.java.Functions;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.springframework.web.reactive.function.client.WebClient;

/*
 * Exception performing whole class analysis ignored.
 */
public class NvdRequester {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(NvdRequester.class);
    private final WebClient client;
    private final NvdClientConfiguration configuration;

    public @Nullable DetailedVulnerabilityView search(@NonNull String cveId) {
        CveApiJson20 results;
        String json;
        try {
            json = (String)this.getClient().get().uri(uriBuilder -> uriBuilder.path(((NvdClientConfiguration.NvdPaths)this.getConfiguration().getPaths()).getV2()).queryParam("cveId", new Object[]{cveId}).build(new Object[0])).retrieve().bodyToMono(String.class).block();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to retrieve CVE with id '{}' from NVD", (Object)cveId, (Object)e);
            return null;
        }
        if (StringUtils.isBlank((CharSequence)json)) {
            LOGGER.warn("Empty response received from NVD for CVE with id '{}'", (Object)cveId);
            return null;
        }
        try {
            results = (CveApiJson20)new ObjectMapper().readValue(json, CveApiJson20.class);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to parse JSON response from NVD for CVE with id '{}'", (Object)cveId, (Object)e);
            return null;
        }
        if (results.getTotalResults() < 1) {
            return null;
        }
        return NvdRequester.from((String)cveId, (CveApiJson20)results);
    }

    private static @Nullable DetailedVulnerabilityView from(@NonNull String cveId, @NonNull CveApiJson20 result) {
        DefCveItem item = result.getVulnerabilities().stream().findFirst().orElse(null);
        if (item == null) {
            LOGGER.warn("Invalid response from NVD for CVE with id '{}'", (Object)cveId);
            return null;
        }
        DetailedVulnerabilityView res = new DetailedVulnerabilityView(null, null, cveId, VulnerabilityType.CVE.name(), VulnerabilityLevel.UNKNOWN.name());
        Optional<CveItem> cve = Optional.ofNullable(item.getCve());
        res.setDescription(cve.map(CveItem::getDescriptions).map(Collection::stream).flatMap(Stream::findFirst).map(LangString::getValue).orElse(""));
        cve.map(CveItem::getReferences).orElseGet(ArrayList::new).stream().map(Reference::getUrl).forEach(arg_0 -> ((DetailedVulnerabilityView)res).addReference(arg_0));
        cve.map(CveItem::getWeaknesses).orElseGet(ArrayList::new).stream().map(Weakness::getDescription).map(Collection::stream).map(Stream::findFirst).filter(Optional::isPresent).map(Optional::get).map(LangString::getValue).filter(s -> s.startsWith("CWE-")).forEach(arg_0 -> ((DetailedVulnerabilityView)res).addCwe(arg_0));
        cve.map(CveItem::getPublished).map(Date::toInstant).map(Instant::toEpochMilli).ifPresent(arg_0 -> ((DetailedVulnerabilityView)res).setPublished(arg_0));
        Optional<Metrics> metrics = cve.map(CveItem::getMetrics);
        metrics.map(Metrics::getCvssMetricV2).orElseGet(ArrayList::new).stream().findFirst().map(NvdRequester::from).map(Functions.peek(scoreView -> res.setSeverity(SeverityComputer.computeCVESeverityScore2((double)scoreView.getBaseScore()).name()))).ifPresent(arg_0 -> ((DetailedVulnerabilityView)res).setScoreV2(arg_0));
        metrics.map(Metrics::getCvssMetricV30).orElseGet(ArrayList::new).stream().findFirst().map(NvdRequester::from).map(Functions.peek(scoreView -> res.setSeverity(SeverityComputer.computeCVESeverityScore3((double)scoreView.getBaseScore()).name()))).ifPresent(arg_0 -> ((DetailedVulnerabilityView)res).setScoreV3(arg_0));
        metrics.map(Metrics::getCvssMetricV31).orElseGet(ArrayList::new).stream().findFirst().map(NvdRequester::from).map(Functions.peek(scoreView -> res.setSeverity(SeverityComputer.computeCVESeverityScore3((double)scoreView.getBaseScore()).name()))).ifPresent(arg_0 -> ((DetailedVulnerabilityView)res).setScoreV3(arg_0));
        return res;
    }

    private static @NonNull ScoreView from(@NonNull CvssV2 metricV2) {
        return new ScoreView(metricV2.getCvssData().getVectorString(), metricV2.getCvssData().getBaseScore(), metricV2.getExploitabilityScore(), metricV2.getImpactScore());
    }

    private static @NonNull ScoreView from(@NonNull CvssV30 metricV3) {
        return new ScoreView(metricV3.getCvssData().getVectorString(), metricV3.getCvssData().getBaseScore(), metricV3.getExploitabilityScore(), metricV3.getImpactScore());
    }

    private static @NonNull ScoreView from(@NonNull CvssV31 metricV3) {
        return new ScoreView(metricV3.getCvssData().getVectorString(), metricV3.getCvssData().getBaseScore(), metricV3.getExploitabilityScore(), metricV3.getImpactScore());
    }

    @Generated
    public WebClient getClient() {
        return this.client;
    }

    @Generated
    public NvdClientConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public NvdRequester(WebClient client, NvdClientConfiguration configuration) {
        this.client = client;
        this.configuration = configuration;
    }
}

