/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.monitoring.handler;

import com.castsoftware.sca.scar.server.monitoring.domain.PhaseType;
import com.castsoftware.sca.scar.server.monitoring.domain.ProgressPhase;
import com.castsoftware.sca.scar.server.monitoring.domain.ProgressStatus;
import com.castsoftware.sca.util.java.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ProgressMonitor {
    private final ConcurrentHashMap<PhaseType, List<Throwable>> errors = new ConcurrentHashMap();
    private ProgressStatus status;
    private double percent = 0.0;
    private ConcurrentHashMap<PhaseType, ProgressPhase> phases = new ConcurrentHashMap();
    private LinkedList<PhaseType> phaseSequence = new LinkedList();

    public ProgressMonitor() {
        this.status = ProgressStatus.WAITING;
    }

    public void reset() {
        this.phases.clear();
        this.phaseSequence.clear();
        this.status = ProgressStatus.WAITING;
        this.percent = 0.0;
    }

    public void addPhase(ProgressPhase phase) {
        Optional.ofNullable(phase).filter(Predicates.negate(p -> this.phases.containsKey(p.getType()))).ifPresent(p -> {
            this.phases.put(p.getType(), p);
            this.phaseSequence.add(p.getType());
        });
    }

    public Collection<ProgressPhase> getPhases() {
        return this.phases.values();
    }

    public ProgressPhase getPhase(PhaseType type) {
        return (ProgressPhase)this.phases.get(type);
    }

    public List<PhaseType> getPhaseSequence() {
        return this.phaseSequence;
    }

    public ProgressStatus getStatus() {
        this.status = this.phases.isEmpty() ? ProgressStatus.WAITING : (this.phases.values().stream().map(ProgressPhase::getStatus).allMatch(arg_0 -> ProgressStatus.DONE.equals(arg_0)) ? ProgressStatus.DONE : (this.phases.values().stream().anyMatch(s -> s.getStatus().equals((Object)ProgressStatus.RUNNING) || s.getStatus().equals((Object)ProgressStatus.DONE)) ? ProgressStatus.RUNNING : ProgressStatus.WAITING));
        return this.status;
    }

    public double getPercent() {
        AtomicInteger totalWeight = new AtomicInteger(0);
        Double pcSum = this.phases.values().stream().peek(n -> totalWeight.addAndGet(n.getWeight())).map(n -> n.getPercent() * (double)n.getWeight()).reduce(0.0, Double::sum);
        this.percent = (double)totalWeight.get() == 0.0 ? 0.0 : pcSum / (double)totalWeight.get();
        return this.percent;
    }

    public void addError(PhaseType phaseType, Throwable error) {
        Optional.ofNullable(phaseType).filter(pt -> Objects.nonNull(error)).ifPresent(pt -> {
            List err = Optional.ofNullable((List)this.errors.get(pt)).orElseGet(ArrayList::new);
            err.add(error);
            this.errors.put(pt, err);
        });
    }

    public Map<PhaseType, List<Throwable>> getErrors() {
        return this.errors;
    }

    public void update() {
        this.getStatus();
        this.getPercent();
    }
}

