/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.monitoring.domain;

import com.castsoftware.sca.scar.server.monitoring.domain.ProgressStatus;
import java.util.concurrent.locks.ReentrantLock;

public class ProgressStep {
    private final transient ReentrantLock lock = new ReentrantLock();
    private ProgressStatus status = ProgressStatus.WAITING;
    private String title;
    private double percent;
    private transient int weight;

    public ProgressStep(String title, int weight) {
        this.title = title;
        this.weight = weight;
        this.percent = 0.0;
    }

    public void start() {
        this.status = ProgressStatus.RUNNING;
    }

    public void add(double adding) {
        try {
            this.lock.lock();
            if (this.status.equals((Object)ProgressStatus.WAITING)) {
                this.status = ProgressStatus.RUNNING;
            }
            this.percent += adding;
            if (this.percent > 100.0) {
                this.percent = 100.0;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() {
        this.status = ProgressStatus.DONE;
        this.percent = 100.0;
    }

    public ProgressStatus getStatus() {
        return this.status;
    }

    public String getTitle() {
        return this.title;
    }

    public int getWeight() {
        return this.weight;
    }

    public double getPercent() {
        return this.percent;
    }
}

