/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.monitoring.domain;

import com.castsoftware.sca.scar.server.monitoring.domain.PhaseType;
import com.castsoftware.sca.scar.server.monitoring.domain.ProgressStatus;
import com.castsoftware.sca.scar.server.monitoring.domain.ProgressStep;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ProgressPhase {
    private String title;
    private ArrayList<ProgressStep> steps;
    private PhaseType type;
    private int weight;
    private double percent;
    private ProgressStatus status;

    public ProgressPhase(PhaseType type, String title, int weight) {
        this.type = type;
        this.title = title;
        this.weight = weight;
        this.steps = new ArrayList();
        this.status = ProgressStatus.WAITING;
        this.percent = 0.0;
    }

    public void addStep(ProgressStep step) {
        this.steps.add(step);
    }

    public List<ProgressStep> getSteps() {
        return this.steps;
    }

    public PhaseType getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public int getWeight() {
        return this.weight;
    }

    public ProgressStatus getStatus() {
        this.status = this.steps.isEmpty() ? ProgressStatus.WAITING : (this.steps.stream().map(ProgressStep::getStatus).allMatch(arg_0 -> ProgressStatus.DONE.equals(arg_0)) ? ProgressStatus.DONE : (this.steps.stream().anyMatch(s -> s.getStatus().equals((Object)ProgressStatus.RUNNING) || s.getStatus().equals((Object)ProgressStatus.DONE)) ? ProgressStatus.RUNNING : ProgressStatus.WAITING));
        return this.status;
    }

    public double getPercent() {
        AtomicInteger totalWeight = new AtomicInteger(0);
        Double pcSum = this.steps.stream().peek(n -> totalWeight.addAndGet(n.getWeight())).map(n -> n.getPercent() * (double)n.getWeight()).reduce(0.0, Double::sum);
        this.percent = (double)totalWeight.get() == 0.0 ? 0.0 : pcSum / (double)totalWeight.get();
        return this.percent;
    }

    public void stop() {
        this.steps.forEach(ProgressStep::stop);
    }
}

