/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.message;

import com.castsoftware.sca.scar.server.message.MessageDomain;
import com.castsoftware.sca.scar.server.message.MessageResolution;
import com.castsoftware.sca.scar.server.message.MessageSeverity;
import org.checkerframework.checker.nullness.qual.NonNull;

public enum MessageType {
    NEW_MANAGER_VERSION(MessageDomain.CONFIG, MessageSeverity.INFO, MessageResolution.BY_PROCESS),
    SBOM_CREATED(MessageDomain.SBOM, MessageSeverity.INFO, MessageResolution.WHEN_ACKNOWLEDGED),
    SBOM_SCAN_FAILED(MessageDomain.SBOM, MessageSeverity.ERROR, MessageResolution.WHEN_ACKNOWLEDGED),
    SCANNER_CONFIG(MessageDomain.CONFIG, MessageSeverity.WARNING, MessageResolution.BY_PROCESS);

    private final MessageDomain domain;
    private final MessageSeverity severity;
    private final MessageResolution resolution;

    private MessageType(@NonNull MessageDomain domain, MessageSeverity severity, MessageResolution resolution) {
        this.domain = domain;
        this.severity = severity;
        this.resolution = resolution;
    }

    public MessageDomain getDomain() {
        return this.domain;
    }

    public MessageSeverity getSeverity() {
        return this.severity;
    }

    public MessageResolution getResolution() {
        return this.resolution;
    }
}

