/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.message;

import com.castsoftware.sca.scar.server.core.model.request.GetRequest;
import com.castsoftware.sca.scar.server.message.Message;
import com.castsoftware.sca.scar.server.message.MessageExceptions;
import com.castsoftware.sca.scar.server.message.MessageMapper;
import com.castsoftware.sca.scar.server.message.MessageRepository;
import com.castsoftware.sca.scar.server.message.MessageResolution;
import com.castsoftware.sca.scar.server.message.MessageResponse;
import com.castsoftware.sca.scar.server.message.MessageType;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class MessageService {
    private final MessageRepository messageRepository;

    public MessageService(@NonNull MessageRepository messageRepository) {
        this.messageRepository = messageRepository;
    }

    public @NonNull Collection<MessageResponse> getAllMessages() {
        return this.messageRepository.findAll().stream().sorted(Comparator.comparing(Message::getTimestamp).reversed()).map(MessageMapper::toResponse).collect(Collectors.toList());
    }

    public @NonNull Collection<MessageResponse> getMessages(GetRequest paginationRequest) {
        if (paginationRequest == null || paginationRequest.getLimit() <= 0) {
            return this.getAllMessages();
        }
        int page = Math.max(paginationRequest.getPage(), 0);
        int limit = paginationRequest.getLimit();
        long skip = (long)page * (long)limit;
        return this.messageRepository.findAll().stream().sorted(Comparator.comparing(Message::getTimestamp).reversed()).skip(skip).limit(limit).map(MessageMapper::toResponse).collect(Collectors.toList());
    }

    public @NonNull Long getMessageCount() {
        return this.messageRepository.count();
    }

    public @NonNull Message createMessage(@NonNull Message message) {
        return this.messageRepository.create(message);
    }

    public void acknowledgeMessage(@NonNull String messageId) {
        Message message = (Message)this.messageRepository.findById(messageId).orElseThrow(() -> MessageExceptions.messageNotFound((String)messageId));
        if (MessageResolution.WHEN_ACKNOWLEDGED != message.getResolution()) {
            throw MessageExceptions.messageCannotBeAcknowledged((String)messageId, (MessageResolution)message.getResolution());
        }
        this.messageRepository.deleteById(messageId);
    }

    public void deleteMessagesByType(@NonNull MessageType type) {
        this.messageRepository.deleteMessagesByType(type);
    }
}

