/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.message;

import com.castsoftware.sca.scar.server.autoconfiguration.component.application.SCArApplication;
import com.castsoftware.sca.scar.server.core.dao.JsonFileRepository;
import com.castsoftware.sca.scar.server.message.Message;
import com.castsoftware.sca.scar.server.message.MessageType;
import com.castsoftware.sca.util.java.Guards;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;

/*
 * Exception performing whole class analysis ignored.
 */
public class MessageRepository
extends JsonFileRepository<Message> {
    public MessageRepository(ObjectMapper objectMapper) {
        this(MessageRepository.getMessagesDirectory(), objectMapper);
    }

    MessageRepository(Path storageDirectory, ObjectMapper objectMapper) {
        super(storageDirectory, "messages.json", objectMapper, objectMapper.constructType(Message.class));
    }

    private static @NonNull Path getMessagesDirectory() {
        return Paths.get((String)SCArApplication.defaultResourceLocation(Path::toString), "messages");
    }

    public @NonNull Message create(@NonNull Message message) {
        Guards.notBlank((String)message.getMessage(), (String)"Message content cannot be null or empty");
        Guards.notNull((Object)message.getType(), (String)"Message type cannot be null");
        String id = UUID.randomUUID().toString();
        message.setId(id);
        message.setTimestamp(Instant.now());
        super.update(id, (Object)message);
        return message;
    }

    public int count() {
        return super.count();
    }

    public Collection<Message> findAll() {
        return super.findAll();
    }

    public Optional<Message> findById(String id) {
        return super.findByKey(id);
    }

    public boolean deleteById(String id) {
        return super.deleteByKey(id);
    }

    public void deleteMessagesByType(@NonNull MessageType type) {
        this.findAll().stream().filter(m -> type.equals((Object)m.getType())).map(Message::getId).toList().forEach(arg_0 -> this.deleteById(arg_0));
    }
}

