/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.license.transformer;

import com.castsoftware.sca.scar.server.bom.domain.BomLicenseVertex;
import com.castsoftware.sca.scar.server.license.domain.ComplianceLevel;
import com.castsoftware.sca.scar.server.license.domain.LicenseCategory;
import com.castsoftware.sca.scar.server.license.domain.LicenseProperty;
import com.castsoftware.sca.scar.server.license.domain.LicenseVertex;
import com.castsoftware.sca.scar.server.license.model.LicenseCategoryView;
import com.castsoftware.sca.scar.server.license.model.LicensePropertyView;
import com.castsoftware.sca.scar.server.license.model.LicenseView;
import com.castsoftware.sca.scar.server.license.model.LightLicenseView;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.util.VertexUtils;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;

/*
 * Exception performing whole class analysis ignored.
 */
public final class LicenseTransformer {
    public static @NonNull LightLicenseView fromLight(@NonNull LicenseVertex lv, @NonNull Map<String, ComplianceLevel> complianceLevelMap) {
        return new LightLicenseView(lv.getId(), VertexUtils.encodeId((Vertex)lv), lv.getSpdxId(), lv.getTitle(), lv.getDescription(), Optional.ofNullable(complianceLevelMap.get(lv.getSpdxId())).orElse(ComplianceLevel.UNKNOWN).name());
    }

    public static @NonNull LightLicenseView fromLight(@NonNull LicenseVertex vertex) {
        return new LightLicenseView(vertex.getId(), VertexUtils.encodeId((Vertex)vertex), vertex.getSpdxId(), vertex.getTitle(), vertex.getDescription(), LicenseTransformer.getComplianceLvl((LicenseVertex)vertex));
    }

    public static @NonNull LicenseView fromFull(@NonNull LicenseVertex vertex) {
        LicenseView view = new LicenseView(vertex.getId(), VertexUtils.encodeId((Vertex)vertex), vertex.getSpdxId(), vertex.getTitle(), vertex.getDescription(), LicenseTransformer.getComplianceLvl((LicenseVertex)vertex));
        view.setCategory(LicenseTransformer.from((LicenseCategory)LicenseCategory.valueOf((String)vertex.getCategory())));
        view.setUrl(vertex.getUrl());
        view.setText(vertex.getText());
        vertex.getProperties().forEach(p -> view.addProperty(LicenseTransformer.from((LicenseProperty)LicenseProperty.valueOf((String)p))));
        return view;
    }

    public static @NonNull LicenseCategoryView from(@NonNull LicenseCategory category) {
        return new LicenseCategoryView(category.name(), category.getTitle(), category.getLevel());
    }

    public static @NonNull LicensePropertyView from(@NonNull LicenseProperty property) {
        return new LicensePropertyView(property.name(), property.getGroup().name(), property.getTitle());
    }

    private static String getComplianceLvl(@NonNull LicenseVertex vertex) {
        return Optional.of(vertex).filter(v -> BomLicenseVertex.class.isAssignableFrom(v.getClass())).map(BomLicenseVertex.class::cast).map(blv -> blv.getComplianceLevel().name()).orElse(null);
    }

    @Generated
    private LicenseTransformer() {
    }
}

