/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.license.transformer;

import com.castsoftware.sca.scar.server.bom.domain.BomLicenseVertex;
import com.castsoftware.sca.scar.server.license.domain.LicensePolicyVertex;
import com.castsoftware.sca.scar.server.license.domain.LicenseVertex;
import com.castsoftware.sca.scar.server.license.model.LicensePolicyView;
import com.castsoftware.sca.scar.server.license.model.LightLicensePolicyView;
import com.castsoftware.sca.scar.server.license.transformer.LicenseTransformer;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.util.VertexUtils;
import com.castsoftware.sca.util.java.Guards;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;

public class LicensePolicyTransformer {
    public static @NonNull LightLicensePolicyView lightFrom(LicensePolicyVertex vertex, String defaultId) {
        Guards.notNull((Object)vertex, IllegalStateException::new);
        LightLicensePolicyView view = new LightLicensePolicyView(vertex.getId(), VertexUtils.encodeId((Vertex)vertex), vertex.getName(), vertex.getTitle(), vertex.getId().equals(defaultId));
        return view;
    }

    public static @NonNull LicensePolicyView from(LicensePolicyVertex vertex, String defaultId, @NonNull List<BomLicenseVertex> licenses) {
        Guards.notNull((Object)vertex, IllegalStateException::new);
        LicensePolicyView view = new LicensePolicyView(vertex.getId(), VertexUtils.encodeId((Vertex)vertex), vertex.getName(), vertex.getTitle(), vertex.getId().equals(defaultId));
        licenses.stream().sorted(Comparator.comparing(LicenseVertex::getSpdxId, String.CASE_INSENSITIVE_ORDER)).forEach(blv -> view.addLicense(LicenseTransformer.fromFull((LicenseVertex)blv)));
        return view;
    }

    @Generated
    private LicensePolicyTransformer() {
    }
}

