/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.license.service;

import com.castsoftware.sca.scar.server.core.dao.FindConfiguration;
import com.castsoftware.sca.scar.server.core.model.request.GetRequest;
import com.castsoftware.sca.scar.server.core.transformer.FindConfigurationTransformers;
import com.castsoftware.sca.scar.server.license.dao.LicenseDao;
import com.castsoftware.sca.scar.server.license.domain.LicenseCategory;
import com.castsoftware.sca.scar.server.license.domain.LicenseProperty;
import com.castsoftware.sca.scar.server.license.domain.LicenseVertex;
import com.castsoftware.sca.scar.server.license.exception.DuplicateLicenseException;
import com.castsoftware.sca.scar.server.license.exception.LicenseAssignedException;
import com.castsoftware.sca.scar.server.license.exception.LicenseExceptions;
import com.castsoftware.sca.scar.server.license.model.LicenseCategoryView;
import com.castsoftware.sca.scar.server.license.model.LicensePropertyView;
import com.castsoftware.sca.scar.server.license.model.LicenseView;
import com.castsoftware.sca.scar.server.license.model.LightLicenseView;
import com.castsoftware.sca.scar.server.license.model.request.LicenseCreateRequest;
import com.castsoftware.sca.scar.server.license.model.request.LicenseEditRequest;
import com.castsoftware.sca.scar.server.license.transformer.LicenseTransformer;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.util.RequestUtils;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class LicenseService {
    private final LicenseDao licenseDao;

    public LicenseService(LicenseDao licenseDao) {
        this.licenseDao = licenseDao;
    }

    public Collection<LightLicenseView> getLicenses(GetRequest paginationRequest) {
        return this.getLicenses(paginationRequest, LicenseTransformer::fromLight);
    }

    public Collection<LicenseView> getLicensesWithDetails(GetRequest paginationRequest) {
        return this.getLicenses(paginationRequest, LicenseTransformer::fromFull);
    }

    private <T extends LightLicenseView> Collection<T> getLicenses(GetRequest paginationRequest, Function<LicenseVertex, T> transformer) {
        FindConfiguration findConfiguration = Optional.ofNullable(paginationRequest).map(FindConfigurationTransformers::from).orElseGet(FindConfiguration::new);
        return this.licenseDao.findAll(findConfiguration).stream().map(Optional.ofNullable(transformer).orElse(lv -> LicenseTransformer.fromLight((LicenseVertex)lv))).collect(Collectors.toList());
    }

    public Long countLicenses() {
        return this.licenseDao.count();
    }

    public LicenseView getLicense(String id) {
        return this.licenseDao.findById(RequestUtils.decodeId((String)id)).map(LicenseTransformer::fromFull).orElseThrow(() -> LicenseExceptions.licenseNotFound((String)id));
    }

    public LightLicenseView createLicense(LicenseCreateRequest request) {
        this.validate((Object)request);
        this.licenseDao.findBySpdxId(request.getSpdxId()).ifPresent(l -> {
            throw new DuplicateLicenseException(request.getSpdxId());
        });
        LicenseVertex newVertex = LicenseService.hydrate((LicenseEditRequest)request, (LicenseVertex)new LicenseVertex(request.getSpdxId()));
        newVertex = (LicenseVertex)this.licenseDao.save((Vertex)newVertex);
        return LicenseTransformer.fromLight((LicenseVertex)newVertex);
    }

    public void editLicense(String id, LicenseEditRequest request) {
        this.validate((Object)request);
        LicenseVertex vertex = (LicenseVertex)this.licenseDao.findById(RequestUtils.decodeId((String)id)).orElseThrow(() -> LicenseExceptions.licenseNotFound((String)id));
        LicenseService.hydrate((LicenseEditRequest)request, (LicenseVertex)vertex);
        this.licenseDao.save((Vertex)vertex);
    }

    public void deleteLicense(String id) {
        LicenseVertex vertex = (LicenseVertex)this.licenseDao.findById(RequestUtils.decodeId((String)id)).orElseThrow(() -> LicenseExceptions.licenseNotFound((String)id));
        boolean isAssignedToExistingPolicy = this.licenseDao.findElementToLicenseEdges(vertex.getId()).stream().findAny().isPresent();
        if (isAssignedToExistingPolicy) {
            throw new LicenseAssignedException(id);
        }
        this.licenseDao.delete((Vertex)vertex);
    }

    public Collection<LicenseCategoryView> getLicenseCategories() {
        return LicenseCategory.stream().map(LicenseTransformer::from).collect(Collectors.toList());
    }

    public Collection<LicensePropertyView> getLicenseProperties() {
        return LicenseProperty.stream().map(LicenseTransformer::from).collect(Collectors.toList());
    }

    private static LicenseVertex hydrate(LicenseEditRequest request, LicenseVertex vertex) {
        Optional<LicenseEditRequest> oRequest = Optional.ofNullable(request);
        vertex.setTitle(oRequest.map(LicenseEditRequest::getTitle).orElse(""));
        vertex.setDescription(oRequest.map(LicenseEditRequest::getDescription).orElse(""));
        vertex.setCategory(oRequest.map(LicenseEditRequest::getCategory).map(LicenseCategory::valueOf).map(Enum::name).orElse(""));
        vertex.setProperties(oRequest.map(LicenseEditRequest::getProperties).orElseGet(ArrayList::new).stream().map(LicenseProperty::valueOf).map(Enum::name).collect(Collectors.toSet()));
        vertex.setUrl(oRequest.map(LicenseEditRequest::getUrl).orElse(""));
        vertex.setText(oRequest.map(LicenseEditRequest::getText).orElse(""));
        return vertex;
    }

    private void validate(Object request) {
        Validator validator;
        try (ValidatorFactory factory = Validation.buildDefaultValidatorFactory();){
            validator = factory.getValidator();
        }
        Set violations = validator.validate(request, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

