/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.license.service;

import com.castsoftware.sca.scar.server.bom.dao.CentralDao;
import com.castsoftware.sca.scar.server.bom.domain.BomLicenseVertex;
import com.castsoftware.sca.scar.server.bom.structure.BOMClassDefinition;
import com.castsoftware.sca.scar.server.kpi.handler.KPIComputer;
import com.castsoftware.sca.scar.server.license.dao.LicenseDao;
import com.castsoftware.sca.scar.server.license.dao.LicensePolicyDao;
import com.castsoftware.sca.scar.server.license.domain.ComplianceLevel;
import com.castsoftware.sca.scar.server.license.domain.LicensePolicyVertex;
import com.castsoftware.sca.scar.server.license.domain.LicenseVertex;
import com.castsoftware.sca.scar.server.license.exception.DuplicateLicensePolicyException;
import com.castsoftware.sca.scar.server.license.exception.LicenseExceptions;
import com.castsoftware.sca.scar.server.license.exception.LicensePolicyAssignedException;
import com.castsoftware.sca.scar.server.license.model.LicensePolicyView;
import com.castsoftware.sca.scar.server.license.model.LightLicensePolicyView;
import com.castsoftware.sca.scar.server.license.model.request.PolicyCreateRequest;
import com.castsoftware.sca.scar.server.license.model.request.PolicyEditRequest;
import com.castsoftware.sca.scar.server.license.model.request.PolicyRemoveLicenseRequest;
import com.castsoftware.sca.scar.server.license.model.request.PolicyTemplate;
import com.castsoftware.sca.scar.server.license.model.request.PolicyUpdateLicenseRequest;
import com.castsoftware.sca.scar.server.license.transformer.LicensePolicyTransformer;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.orientdb.structure.EClassDefinition;
import com.castsoftware.sca.scar.server.util.RequestUtils;
import com.castsoftware.sca.scar.server.util.event.EventListener;
import com.castsoftware.sca.util.java.Suppliers;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

public class LicensePolicyService {
    private final LicenseDao licenseDao;
    private final LicensePolicyDao licensePolicyDao;
    private final CentralDao centralDao;
    private final KPIComputer kpiComputer;
    private static final ReentrantLock defaultPolicyLock = new ReentrantLock();

    public LicensePolicyService(LicenseDao licenseDao, LicensePolicyDao licensePolicyDao, CentralDao centralDao, KPIComputer kpiComputer) {
        this.licenseDao = licenseDao;
        this.licensePolicyDao = licensePolicyDao;
        this.centralDao = centralDao;
        this.kpiComputer = kpiComputer;
    }

    public Collection<LightLicensePolicyView> getPolicies() {
        String defaultId = this.centralDao.getDefaultPolicy().getId();
        return this.licensePolicyDao.findAll().stream().map(lp -> LicensePolicyTransformer.lightFrom((LicensePolicyVertex)lp, (String)defaultId)).collect(Collectors.toList());
    }

    public LicensePolicyView getPolicy(String id) {
        LicensePolicyVertex policy = (LicensePolicyVertex)this.licensePolicyDao.findById(RequestUtils.decodeId((String)id)).orElseThrow(() -> LicenseExceptions.licensePolicyNotFound((String)id));
        List licenses = this.licenseDao.findPolicyLicenses(policy.getId());
        String defaultId = this.centralDao.getDefaultPolicy().getId();
        return LicensePolicyTransformer.from((LicensePolicyVertex)policy, (String)defaultId, (List)licenses);
    }

    public LightLicensePolicyView createPolicy(PolicyCreateRequest request) {
        this.validate((Object)request);
        String name = request.getName();
        this.licensePolicyDao.findByName(name).ifPresent(p -> {
            throw new DuplicateLicensePolicyException(name);
        });
        LicensePolicyVertex vertex = new LicensePolicyVertex(name);
        vertex.setTitle(request.getTitle());
        ArrayList<BomLicenseVertex> toAttach = new ArrayList<BomLicenseVertex>();
        if (PolicyTemplate.copy.equals((Object)request.getPolicyTemplate())) {
            toAttach.addAll(this.licenseDao.findPolicyLicenses(RequestUtils.decodeId((String)request.getCopyId())));
        }
        if (PolicyTemplate.fullBlank.equals((Object)request.getPolicyTemplate())) {
            toAttach.addAll(this.licenseDao.findAll().stream().map(l -> new BomLicenseVertex(l, ComplianceLevel.UNKNOWN)).toList());
        }
        this.licensePolicyDao.withTransaction(session -> {
            LicensePolicyVertex saved = (LicensePolicyVertex)this.licensePolicyDao.save((Vertex)vertex, session);
            toAttach.forEach(blv -> this.licensePolicyDao.link((Vertex)saved, (Vertex)blv, (EClassDefinition)blv.getComplianceLevel().getLinkStatus(), session));
        });
        LicensePolicyVertex lpv = (LicensePolicyVertex)this.licensePolicyDao.findByName(vertex.getName()).orElseThrow(Suppliers.illegalState((String)"not found"));
        String defaultId = this.centralDao.getDefaultPolicy().getId();
        return LicensePolicyTransformer.lightFrom((LicensePolicyVertex)lpv, (String)defaultId);
    }

    public void editPolicy(String id, PolicyEditRequest request) {
        this.validate((Object)request);
        LicensePolicyVertex policy = (LicensePolicyVertex)this.licensePolicyDao.findById(RequestUtils.decodeId((String)id)).orElseThrow(() -> LicenseExceptions.licensePolicyNotFound((String)id));
        String name = request.getName();
        if (!policy.getName().equals(name)) {
            this.licensePolicyDao.findByName(name).ifPresent(p -> {
                throw new DuplicateLicensePolicyException(name);
            });
            policy.setName(name);
        }
        policy.setTitle(request.getTitle());
        this.licensePolicyDao.save((Vertex)policy);
    }

    public void deletePolicy(String licensePolicyId) {
        LicensePolicyVertex policy = (LicensePolicyVertex)this.licensePolicyDao.findById(RequestUtils.decodeId((String)licensePolicyId)).orElseThrow(() -> LicenseExceptions.licensePolicyNotFound((String)licensePolicyId));
        this.licensePolicyDao.findBomToPolicyEdges(policy.getId()).stream().findAny().ifPresent(edge -> {
            throw new LicensePolicyAssignedException(licensePolicyId);
        });
        Optional.ofNullable(this.centralDao.getDefaultPolicy()).filter(defaultPolicy -> defaultPolicy.getId().equals(policy.getId())).ifPresent(p -> {
            throw new LicensePolicyAssignedException(licensePolicyId);
        });
        this.licensePolicyDao.delete((Vertex)policy);
    }

    public void addOrUpdateLicense(String id, PolicyUpdateLicenseRequest request) {
        this.validate((Object)request);
        this.licensePolicyDao.withTransaction(session -> {
            LicensePolicyVertex policy = (LicensePolicyVertex)this.licensePolicyDao.findById(RequestUtils.decodeId((String)id), session).orElseThrow(() -> LicenseExceptions.licensePolicyNotFound((String)id));
            LicenseVertex license = (LicenseVertex)this.licenseDao.findById(RequestUtils.decodeId((String)request.getUpdateId()), session).orElseThrow(Suppliers.illegalArgument((String)"Unknown license Id"));
            BOMClassDefinition.E linkStatus = Optional.ofNullable(request.getCompliance()).map(ComplianceLevel::valueOf).orElse(ComplianceLevel.UNKNOWN).getLinkStatus();
            this.licensePolicyDao.unlink((Vertex)policy, (Vertex)license, (EClassDefinition)BOMClassDefinition.E.EPolicyStatus, session);
            this.licensePolicyDao.link((Vertex)policy, (Vertex)license, (EClassDefinition)linkStatus, session);
        });
        this.kpiComputer.computeAllBomsLicenseKPIBackground(RequestUtils.decodeId((String)id), new EventListener[0]);
    }

    public void removeLicense(String id, PolicyRemoveLicenseRequest request) {
        this.validate((Object)request);
        LicensePolicyVertex policy = (LicensePolicyVertex)this.licensePolicyDao.findById(RequestUtils.decodeId((String)id)).orElseThrow(() -> LicenseExceptions.licensePolicyNotFound((String)id));
        LicenseVertex license = (LicenseVertex)this.licenseDao.findById(RequestUtils.decodeId((String)request.getRemoveId())).orElseThrow(Suppliers.illegalArgument((String)"unknown license Id"));
        this.licensePolicyDao.removeLicense(policy, license, BOMClassDefinition.E.EPolicyStatus, null);
        this.kpiComputer.computeAllBomsLicenseKPIBackground(RequestUtils.decodeId((String)id), new EventListener[0]);
    }

    public LightLicensePolicyView getDefaultPolicy() {
        LicensePolicyVertex lpd = this.centralDao.getDefaultPolicy();
        return LicensePolicyTransformer.lightFrom((LicensePolicyVertex)lpd, (String)lpd.getId());
    }

    public void setDefaultPolicy(String id) {
        defaultPolicyLock.lock();
        try {
            LicensePolicyVertex newDefault = (LicensePolicyVertex)this.licensePolicyDao.findById(RequestUtils.decodeId((String)id)).orElseThrow(() -> LicenseExceptions.licensePolicyNotFound((String)id));
            this.centralDao.setDefaultPolicy(newDefault);
        }
        finally {
            defaultPolicyLock.unlock();
        }
    }

    private void validate(Object request) {
        Validator validator;
        try (ValidatorFactory factory = Validation.buildDefaultValidatorFactory();){
            validator = factory.getValidator();
        }
        Set violations = validator.validate(request, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }
}

