/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.license.domain;

import com.castsoftware.sca.scar.server.bom.structure.BOMClassDefinition;
import com.castsoftware.sca.scar.server.license.domain.LicenseCategory;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.orientdb.structure.VClassDefinition;
import com.castsoftware.sca.scar.server.util.visitable.SCArVertexVisitor;
import com.castsoftware.sca.util.java.Predicates;
import com.orientechnologies.orient.core.record.impl.OVertexDocument;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class LicenseVertex
extends Vertex<SCArVertexVisitor> {
    public LicenseVertex(String spdxId) {
        this.setProperty("spdxId", (Object)spdxId, Predicates.notEmptyString());
    }

    public LicenseVertex(OVertexDocument vertex) {
        super(vertex);
    }

    public VClassDefinition definition() {
        return BOMClassDefinition.V.VLicense;
    }

    public String getSpdxId() {
        return (String)this.getPropertyOrNull("spdxId");
    }

    public String getTitle() {
        return (String)this.getProperty("title", (Object)"");
    }

    public void setTitle(String title) {
        this.setProperty("title", (Object)title, Predicates.notEmptyString());
    }

    public String getDescription() {
        return (String)this.getProperty("description", (Object)"");
    }

    public void setDescription(String description) {
        this.setProperty("description", (Object)description);
    }

    public String getCategory() {
        return (String)this.getProperty("category", (Object)LicenseCategory.UNKNOWN.name());
    }

    public void setCategory(String category) {
        this.setProperty("category", (Object)category, Predicates.notEmptyString());
    }

    public List<String> getExceptions() {
        return (List)this.getProperty("exceptions", ArrayList::new);
    }

    public void setExceptions(List<String> exceptions) {
        this.setProperty("exceptions", exceptions, Predicates.notEmptyCollection());
    }

    public Set<String> getProperties() {
        return (Set)this.getProperty("properties", HashSet::new);
    }

    public void setProperties(Set<String> properties) {
        this.setProperty("properties", properties, Predicates.notEmptyCollection());
    }

    public String getUrl() {
        return (String)this.getProperty("url", (Object)"");
    }

    public void setUrl(String url) {
        this.setProperty("url", (Object)url);
    }

    public String getText() {
        return (String)this.getProperty("text", (Object)"");
    }

    public void setText(String text) {
        this.setProperty("text", (Object)text);
    }

    public void accept(SCArVertexVisitor visitor) {
        visitor.visit(this);
    }

    protected Boolean isValid(OVertexDocument vertex) {
        return Optional.ofNullable(vertex).filter(v -> v.getPropertyNames().contains("spdxId")).map(v -> (String)v.getProperty("spdxId")).filter(Predicates.notEmptyString()).isPresent();
    }
}

