/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.license.domain;

import com.castsoftware.sca.scar.server.bom.structure.BOMClassDefinition;
import com.castsoftware.sca.util.java.Functions;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import java.util.Optional;
import java.util.stream.Stream;

/*
 * Exception performing whole class analysis ignored.
 */
public enum ComplianceLevel {
    UNKNOWN(BOMClassDefinition.E.EPolicyUnknown, 100),
    YES(BOMClassDefinition.E.EPolicyOk, 1),
    NO(BOMClassDefinition.E.EPolicyNo, 1000000),
    CONDITIONAL(BOMClassDefinition.E.EPolicyConditional, 10000);

    private final BOMClassDefinition.E linkStatus;
    private final int sortMultiplier;

    public static Stream<ComplianceLevel> stream() {
        return Stream.of(ComplianceLevel.values());
    }

    public static ComplianceLevel valueOfLinkStatus(String linkStatus) {
        return ComplianceLevel.stream().filter(complianceLevel -> complianceLevel.getLinkStatus().name().equals(linkStatus)).findFirst().orElseThrow(IllegalArgumentException::new);
    }

    public static ComplianceLevel from(OEdge edge) {
        return Optional.of(edge).flatMap(OElement::getSchemaType).map(OClass::getName).map(Functions.evictThrowable(ComplianceLevel::valueOfLinkStatus)).orElse(UNKNOWN);
    }

    private ComplianceLevel(BOMClassDefinition.E linkStatus, int sortMultiplier) {
        this.linkStatus = linkStatus;
        this.sortMultiplier = sortMultiplier;
    }

    public BOMClassDefinition.E getLinkStatus() {
        return this.linkStatus;
    }

    public int getSortMultiplier() {
        return this.sortMultiplier;
    }
}

