/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.license.dao;

import com.castsoftware.sca.scar.server.bom.domain.BomLicenseVertex;
import com.castsoftware.sca.scar.server.bom.structure.BOMClassDefinition;
import com.castsoftware.sca.scar.server.core.dao.FindConfiguration;
import com.castsoftware.sca.scar.server.core.dao.PaginationConfiguration;
import com.castsoftware.sca.scar.server.license.dao.LicenseDao;
import com.castsoftware.sca.scar.server.license.domain.ComplianceLevel;
import com.castsoftware.sca.scar.server.license.domain.LicenseVertex;
import com.castsoftware.sca.scar.server.orientdb.dao.GraphDao;
import com.castsoftware.sca.scar.server.orientdb.structure.EClassDefinition;
import com.castsoftware.sca.scar.server.orientdb.structure.VClassDefinition;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.impl.OVertexDocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.jooq.Query;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectWhereStep;
import org.jooq.SortOrder;
import org.jooq.impl.DSL;

/*
 * Exception performing whole class analysis ignored.
 */
public class LicenseDao
extends GraphDao<LicenseVertex> {
    public LicenseDao(ODatabasePool oDatabasePool) {
        super(oDatabasePool, (VClassDefinition)BOMClassDefinition.V.VLicense);
    }

    public Optional<LicenseVertex> findBySpdxId(String spdxId) {
        List result = this.listDomain(arg_0 -> ((VClassDefinition)this.definition).newInstance(arg_0), (Query)this.queryBuilder.selectFrom(this.definition.name()).where(Fields.SPDX_ID.eq((Object)spdxId)), new Object[]{spdxId});
        return result.stream().findFirst();
    }

    public List<LicenseVertex> findAll(FindConfiguration findConfiguration) {
        SelectWhereStep query = this.queryBuilder.selectFrom(this.definition.name());
        Optional<FindConfiguration> fc = Optional.ofNullable(findConfiguration);
        fc.map(FindConfiguration::getSort).filter(sc -> CollectionUtils.isNotEmpty((Collection)sc.getSort())).map(sc -> sc.getSort().stream().map(s -> DSL.field((String)s).sort(sc.isAscend() ? SortOrder.ASC : SortOrder.DESC)).collect(Collectors.toList())).ifPresent(arg_0 -> ((SelectWhereStep)query).orderBy(arg_0));
        String queryAsString = fc.map(FindConfiguration::getPagination).filter(p -> p.getLimit() > 0).map(this.paginate(query)).orElse(query.toString());
        return this.listVertex(null, arg_0 -> ((VClassDefinition)this.definition).newInstance(arg_0), queryAsString, new Object[0]);
    }

    private Function<PaginationConfiguration, String> paginate(SelectWhereStep<?> query) {
        return paginationConfiguration -> String.format("%s SKIP %d", query.limit((Number)paginationConfiguration.getLimit()).toString(), paginationConfiguration.getStartAt());
    }

    public List<BomLicenseVertex> findBomLicenses(String bomId) {
        Stream<GraphDao.TraverseType> policyTraverseTypeChained = Stream.of(GraphDao.TraverseType.OUT_DEFINED_EDGE, GraphDao.TraverseType.IN_DEFINED_VERTEX, GraphDao.TraverseType.OUT_DEFINED_EDGE);
        String policyProjection = GraphDao.TraverseType.concat(policyTraverseTypeChained, (String[])new String[]{BOMClassDefinition.E.EPolicy.name(), BOMClassDefinition.V.VLicensePolicy.name(), BOMClassDefinition.E.EPolicyStatus.name()});
        String policyStatusOfBom = LicenseDao.traverse((String)policyProjection, (String)bomId, (Integer)2);
        String licenseAssociate = LicenseDao.traverse((String)GraphDao.TraverseType.IN_DEFINED_VERTEX.value(new String[]{BOMClassDefinition.V.VLicense.name()}), (String)policyStatusOfBom, (Integer)2);
        return this.getBomLicenseVertices(licenseAssociate, BOMClassDefinition.V.VBom);
    }

    public List<BomLicenseVertex> findPolicyLicenses(String policyId) {
        String policyStatus = LicenseDao.traverse((String)GraphDao.TraverseType.OUT_DEFINED_EDGE.value(new String[]{BOMClassDefinition.E.EPolicyStatus.name()}), (String)policyId, (Integer)1);
        String licenseAssociate = LicenseDao.traverse((String)GraphDao.TraverseType.IN_DEFINED_VERTEX.value(new String[]{BOMClassDefinition.V.VLicense.name()}), (String)policyStatus, (Integer)2);
        return this.getBomLicenseVertices(licenseAssociate, BOMClassDefinition.V.VLicensePolicy);
    }

    public List<OEdge> findElementToLicenseEdges(String licenseId) {
        return this.listInEdge(e -> e, licenseId, (EClassDefinition)BOMClassDefinition.E.ELicense);
    }

    public Long count() {
        return (Long)this.query(session -> session.countClass(this.definition.name()));
    }

    public Long countByBom(String bomId) {
        return (Long)this.query(session -> {
            String traverseComponent = LicenseDao.traverse((String)GraphDao.TraverseType.OUT_DEFINED.value(new String[]{BOMClassDefinition.E.ECategory.name()}), (String)bomId, (Integer)2);
            String traverseLicense = LicenseDao.traverse((String)GraphDao.TraverseType.OUT_DEFINED.value(new String[]{BOMClassDefinition.E.ELicense.name()}), (String)traverseComponent, (Integer)2);
            String query = this.queryBuilder.select((SelectField)DSL.count().as("count")).from(traverseLicense).where(GraphDao.MetaFields.clazz.eq((Object)BOMClassDefinition.V.VLicense.name())).toString();
            return session.query(query, new Object[0]).stream().filter(r -> r.hasProperty("count")).map(r -> r.getProperty("count")).map(Long.class::cast).findFirst().orElse(-1L);
        });
    }

    private List<BomLicenseVertex> getBomLicenseVertices(String licenseAssociate, BOMClassDefinition.V vFromFilter) {
        return (List)this.query(session -> {
            HashMap licenceIdComplianceLevel = new HashMap();
            ArrayList licenseIdLicense = new ArrayList();
            SelectConditionStep query = this.queryBuilder.selectFrom(licenseAssociate).where(GraphDao.MetaFields.clazz.ne((Object)vFromFilter.name()));
            session.query(query.toString(), new Object[0]).forEachRemaining(oResult -> {
                if (oResult.isVertex()) {
                    licenseIdLicense.add(new LicenseVertex((OVertexDocument)OVertexDocument.class.cast(oResult.getVertex().get())));
                } else {
                    oResult.getEdge().ifPresent(edge -> licenceIdComplianceLevel.put(((OVertexDocument)edge.getProperty(GraphDao.MetaFields.in.getName())).getIdentity(), ComplianceLevel.from((OEdge)edge)));
                }
            });
            return licenseIdLicense.stream().map(licenseVertex -> new BomLicenseVertex(licenseVertex, Optional.ofNullable((ComplianceLevel)licenceIdComplianceLevel.get(licenseVertex.getORID())).orElse(ComplianceLevel.UNKNOWN))).collect(Collectors.toList());
        });
    }
}

