/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.kpi.service;

import com.castsoftware.sca.scar.server.bom.dao.BomDao;
import com.castsoftware.sca.scar.server.bom.domain.BomVertex;
import com.castsoftware.sca.scar.server.bom.exception.BomExceptions;
import com.castsoftware.sca.scar.server.kpi.handler.KPIComputer;
import com.castsoftware.sca.scar.server.kpi.service.RecomputeService;
import com.castsoftware.sca.scar.server.util.RequestUtils;
import com.castsoftware.sca.scar.server.util.event.EventListener;

public class RecomputeService {
    private final KPIComputer computer;
    private final BomDao bomDao;

    public RecomputeService(KPIComputer computer, BomDao bomDao) {
        this.computer = computer;
        this.bomDao = bomDao;
    }

    public String recomputeBasicKpi(String bomId) {
        BomVertex bom = (BomVertex)this.bomDao.findById(RequestUtils.decodeId((String)bomId)).orElseThrow(() -> BomExceptions.bomNotFound((String)bomId));
        return this.computer.computeBasicKPIBackground(bom, new EventListener[]{LoggerEventListener.instance});
    }
}

