/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.kpi.ioc;

import com.castsoftware.sca.scar.server.application.configuration.KpiProperties;
import com.castsoftware.sca.scar.server.application.configuration.ScarServerProperties;
import com.castsoftware.sca.scar.server.application.configuration.TaskExecutorProperties;
import com.castsoftware.sca.scar.server.bom.dao.BomDao;
import com.castsoftware.sca.scar.server.bom.dao.FileDao;
import com.castsoftware.sca.scar.server.bom.dao.SnippetDao;
import com.castsoftware.sca.scar.server.component.dao.ComponentDao;
import com.castsoftware.sca.scar.server.kpi.dao.KPIDao;
import com.castsoftware.sca.scar.server.kpi.domain.BomBaseKPI;
import com.castsoftware.sca.scar.server.kpi.handler.AggregatedDataFetcher;
import com.castsoftware.sca.scar.server.kpi.handler.KPIComputer;
import com.castsoftware.sca.scar.server.kpi.service.RecomputeService;
import com.castsoftware.sca.scar.server.license.dao.LicenseDao;
import com.castsoftware.sca.scar.server.license.dao.LicensePolicyDao;
import com.castsoftware.sca.scar.server.util.task.TaskExecutor;
import com.castsoftware.sca.scar.server.vulnerability.dao.VulnerabilityDao;
import com.orientechnologies.orient.core.db.ODatabasePool;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class KPIIOC {
    @Bean
    public KPIDao kpiDao(ODatabasePool pool) {
        return new KPIDao(pool);
    }

    @Bean
    public TaskExecutor<BomBaseKPI> bomKPIBaseTaskExecutor(ScarServerProperties scarServerProperties, ExecutorService executorService) {
        return new TaskExecutor(executorService, Optional.of(scarServerProperties).map(ScarServerProperties::getKpi).map(KpiProperties::getRecompute).map(TaskExecutorProperties::getParallel).orElse(5));
    }

    @Bean
    public AggregatedDataFetcher aggregatedDataFetcher(BomDao bomDao, ComponentDao componentDao, LicenseDao licenseDao, FileDao fileDao) {
        return new AggregatedDataFetcher(bomDao, componentDao, licenseDao, fileDao);
    }

    @Bean
    public KPIComputer kpiComputer(KPIDao kpiDao, AggregatedDataFetcher dataFetcher, BomDao bomDao, ComponentDao componentDao, FileDao filedao, SnippetDao snippetDao, LicenseDao licenseDao, LicensePolicyDao licensePolicyDao, VulnerabilityDao vulnerabilityDao, TaskExecutor<BomBaseKPI> bomBaseKPIExecutor) {
        return new KPIComputer(kpiDao, dataFetcher, bomDao, componentDao, filedao, snippetDao, licenseDao, licensePolicyDao, vulnerabilityDao, bomBaseKPIExecutor);
    }

    @Bean
    public RecomputeService recomputeService(KPIComputer kpiComputer, BomDao bomDao) {
        return new RecomputeService(kpiComputer, bomDao);
    }
}

