/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.kpi.handler;

import com.castsoftware.sca.scar.server.bom.dao.BomDao;
import com.castsoftware.sca.scar.server.bom.dao.FileDao;
import com.castsoftware.sca.scar.server.bom.dao.SnippetDao;
import com.castsoftware.sca.scar.server.bom.domain.BomVertex;
import com.castsoftware.sca.scar.server.component.dao.ComponentDao;
import com.castsoftware.sca.scar.server.kpi.dao.KPIDao;
import com.castsoftware.sca.scar.server.kpi.domain.BomBaseKPI;
import com.castsoftware.sca.scar.server.kpi.domain.KPI;
import com.castsoftware.sca.scar.server.kpi.domain.KPIVertex;
import com.castsoftware.sca.scar.server.kpi.handler.AggregatedDataFetcher;
import com.castsoftware.sca.scar.server.kpi.handler.KPIComputer;
import com.castsoftware.sca.scar.server.license.dao.LicenseDao;
import com.castsoftware.sca.scar.server.license.dao.LicensePolicyDao;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.util.event.Event;
import com.castsoftware.sca.scar.server.util.event.EventListener;
import com.castsoftware.sca.scar.server.util.task.TaskExecutor;
import com.castsoftware.sca.scar.server.util.task.TaskRunnable;
import com.castsoftware.sca.scar.server.vulnerability.dao.VulnerabilityDao;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;

public class KPIComputer {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(KPIComputer.class);
    private final KPIDao kpiDao;
    private final BomDao bomDao;
    private final ComponentDao componentDao;
    private final FileDao fileDao;
    private final SnippetDao snippetDao;
    private final LicenseDao licenseDao;
    private final LicensePolicyDao licensePolicyDao;
    private final VulnerabilityDao vulnerabilityDao;
    private final AggregatedDataFetcher dataFetcher;
    private final TaskExecutor<BomBaseKPI> bomBaseKPIExecutor;

    public KPIComputer(KPIDao kpiDao, AggregatedDataFetcher dataFetcher, BomDao bomDao, ComponentDao componentDao, FileDao fileDao, SnippetDao snippetDao, LicenseDao licenseDao, LicensePolicyDao licensePolicyDao, VulnerabilityDao vulnerabilityDao, TaskExecutor<BomBaseKPI> bomBaseKPIExecutor) {
        this.kpiDao = kpiDao;
        this.dataFetcher = dataFetcher;
        this.bomDao = bomDao;
        this.componentDao = componentDao;
        this.fileDao = fileDao;
        this.snippetDao = snippetDao;
        this.licenseDao = licenseDao;
        this.licensePolicyDao = licensePolicyDao;
        this.vulnerabilityDao = vulnerabilityDao;
        this.bomBaseKPIExecutor = bomBaseKPIExecutor;
    }

    public String computeBasicKPIBackground(BomVertex bomVertex, EventListener ... listeners) {
        return this.bomBaseKPIExecutor.execute((TaskRunnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String computeLicenseKPIBackground(BomVertex bomVertex, EventListener ... listeners) {
        return this.bomBaseKPIExecutor.execute((TaskRunnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String computeAllBomsLicenseKPIBackground(String policyId, EventListener ... listeners) {
        return this.bomBaseKPIExecutor.execute((TaskRunnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String computeLinkedBomsVulnerabilityKPIBackground(String vulnerabilityId, EventListener ... listeners) {
        return this.bomBaseKPIExecutor.execute((TaskRunnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public KPIVertex computeBasicKPI(BomVertex bomVertex, EventListener ... listeners) {
        this.notify((Event)new Events.StartComputeEvent(), listeners);
        KPIVertex vertex = this.kpiDao.findByBom(bomVertex.getId()).orElseGet(() -> this.createBasicKPI(bomVertex));
        this.notify((Event)new Events.ComponentsCountComputeEvent(), listeners);
        vertex.addKPI(KPI.components, (Number)this.componentDao.countByBom(bomVertex.getId()));
        this.notify((Event)new Events.FilesCountComputeEvent(), listeners);
        vertex.addKPI(KPI.files, (Number)this.fileDao.countByBom(bomVertex.getId()));
        vertex.addKPI(KPI.snippets, (Number)this.snippetDao.countByBom(bomVertex.getId()));
        this.notify((Event)new Events.LicensesCountComputeEvent(), listeners);
        vertex.addKPI(KPI.licenses, (Number)this.licenseDao.countByBom(bomVertex.getId()));
        this.notify((Event)new Events.VulnerabilitiesCountComputeEvent(), listeners);
        vertex.addKPI(KPI.vulnerabilities, (Number)this.vulnerabilityDao.countByBom(bomVertex.getId()));
        this.notify((Event)new Events.BomAggregatedComputeEvent(), listeners);
        this.dataFetcher.computeBomAggregatedKpis(bomVertex.getId()).forEach((arg_0, arg_1) -> ((KPIVertex)vertex).addAggregatedKPI(arg_0, arg_1));
        this.notify((Event)new Events.ComponentAggregatedComputeEvent(), listeners);
        this.dataFetcher.computeComponentAggregatedKpis(bomVertex.getId()).forEach((arg_0, arg_1) -> ((KPIVertex)vertex).addAggregatedKPI(arg_0, arg_1));
        this.notify((Event)new Events.FileAggregatedComputeEvent(), listeners);
        this.dataFetcher.computeFileAggregatedKpis(bomVertex.getId()).forEach((arg_0, arg_1) -> ((KPIVertex)vertex).addAggregatedKPI(arg_0, arg_1));
        KPIVertex kpiVertex = (KPIVertex)this.kpiDao.save((Vertex)vertex);
        this.notify((Event)Event.finish(this.getClass()), listeners);
        return kpiVertex;
    }

    public void computeKPIAfterPolicyChange(BomVertex bomVertex, EventListener ... listeners) {
        this.notify((Event)new Events.StartComputeEvent(), listeners);
        this.notify((Event)new Events.LicensesCountComputeEvent(), listeners);
        KPIVertex vertex = this.kpiDao.findByBom(bomVertex.getId()).orElseGet(() -> this.createBasicKPI(bomVertex));
        vertex.addAggregatedKPI(KPI.components_byCompliances, this.dataFetcher.computeLicenseKPIForPolicyChange(bomVertex.getId()));
        this.kpiDao.save((Vertex)vertex);
        this.notify((Event)Event.finish(this.getClass()), listeners);
    }

    public void computeKPIAfterPolicyEdit(String policyId, EventListener ... listeners) {
        this.notify((Event)new Events.StartComputeEvent(), listeners);
        this.notify((Event)new Events.LicensesCountComputeEvent(), listeners);
        this.licensePolicyDao.findLinkedBoms(policyId).forEach(bom -> {
            KPIVertex vertex = this.kpiDao.findByBom(bom.getId()).orElseGet(() -> this.createBasicKPI(bom));
            vertex.addAggregatedKPI(KPI.components_byCompliances, this.dataFetcher.computeLicenseKPIForPolicyChange(bom.getId()));
            this.kpiDao.save((Vertex)vertex);
        });
        this.notify((Event)Event.finish(this.getClass()), listeners);
    }

    public void computeKPIAfterVulnerabilityEdit(String vulnerabilityId, EventListener ... listeners) {
        try {
            this.notify((Event)new Events.StartComputeEvent(), listeners);
            this.notify((Event)new Events.VulnerabilitiesCountComputeEvent(), listeners);
            this.vulnerabilityDao.findLinkedBoms(vulnerabilityId).forEach(bom -> {
                KPIVertex vertex = this.kpiDao.findByBom(bom.getId()).orElseGet(() -> this.createBasicKPI(bom));
                vertex.addAggregatedKPI(KPI.components_ByVulnerabilities, this.dataFetcher.computeVulnerabilityKPIForVulnerabilityChange(bom.getId()));
                this.kpiDao.save((Vertex)vertex);
            });
            this.notify((Event)Event.finish(this.getClass()), listeners);
        }
        catch (Throwable t) {
            System.out.println("fsd");
        }
    }

    private KPIVertex createBasicKPI(BomVertex bomVertex) {
        return (KPIVertex)this.bomDao.getWithTransaction(session -> {
            KPIVertex saved = (KPIVertex)this.kpiDao.save((Vertex)new KPIVertex(), session);
            this.bomDao.addKPI(bomVertex, saved, session);
            return saved;
        });
    }

    private <EVENT extends Event<?>> void notify(EVENT event, EventListener ... listeners) {
        Optional.ofNullable(listeners).map(Stream::of).orElseGet(Stream::empty).forEach(l -> l.on(event));
    }
}

