/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.kpi.handler;

import com.castsoftware.sca.scar.server.analyzer.structure.DefaultCategory;
import com.castsoftware.sca.scar.server.bom.dao.BomDao;
import com.castsoftware.sca.scar.server.bom.dao.FileDao;
import com.castsoftware.sca.scar.server.bom.domain.BomComponentVertex;
import com.castsoftware.sca.scar.server.bom.domain.BomLicenseVertex;
import com.castsoftware.sca.scar.server.bom.domain.CategoryInfo;
import com.castsoftware.sca.scar.server.bom.domain.FileVertex;
import com.castsoftware.sca.scar.server.component.dao.ComponentDao;
import com.castsoftware.sca.scar.server.component.domain.ComponentVertex;
import com.castsoftware.sca.scar.server.kpi.domain.KPI;
import com.castsoftware.sca.scar.server.license.dao.LicenseDao;
import com.castsoftware.sca.scar.server.license.domain.ComplianceLevel;
import com.castsoftware.sca.scar.server.license.domain.LicenseVertex;
import com.castsoftware.sca.scar.server.orientdb.domain.NamedVertex;
import com.castsoftware.sca.scar.server.risk.ObsolescenceLevel;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityLevel;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityVertex;
import com.castsoftware.sca.util.java.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AggregatedDataFetcher {
    private static final int TOP10VALUE = 10;
    private final BomDao bomDao;
    private final ComponentDao componentDao;
    private final LicenseDao licenseDao;
    private final FileDao fileDao;

    public AggregatedDataFetcher(BomDao bomDao, ComponentDao componentDao, LicenseDao licenseDao, FileDao fileDao) {
        this.bomDao = bomDao;
        this.componentDao = componentDao;
        this.licenseDao = licenseDao;
        this.fileDao = fileDao;
    }

    public Map<KPI, Map<String, Number>> computeBomAggregatedKpis(String bomId) {
        HashMap<KPI, Map<String, Number>> results = new HashMap<KPI, Map<String, Number>>();
        Map<String, Number> byCatResult = this.bomDao.findCategoryInfo(bomId).stream().collect(Collectors.toMap(CategoryInfo::getReference, CategoryInfo::getComponents));
        DefaultCategory.stream().filter(Predicates.negate(c -> byCatResult.containsKey(c.name()))).forEach(c -> byCatResult.put(c.name(), 0L));
        results.put(KPI.components_byCategories, byCatResult);
        return results;
    }

    public Map<KPI, Map<String, Number>> computeComponentAggregatedKpis(String bomId) {
        HashMap<KPI, Map<String, Number>> results = new HashMap<KPI, Map<String, Number>>();
        Collection components = this.componentDao.findBomComponents(bomId);
        results.put(KPI.components_top10Languages, this.computeTop10Values(components, ComponentVertex::getLanguages));
        results.put(KPI.components_top10Topics, this.computeTop10Values(components, ComponentVertex::getTopics));
        results.put(KPI.components_top10Licenses, this.computeTop10Values(components, c -> c.getLicenses().stream().map(LicenseVertex::getSpdxId).collect(Collectors.toList())));
        results.put(KPI.components_byCompliances, this.computeComponentsCompliance(bomId, components));
        results.put(KPI.components_byObsolescence, this.computeComponentsObsolescence(components));
        results.put(KPI.components_ByVulnerabilities, this.computeComponentsVulnerabilities(components));
        results.put(KPI.files_bySources, this.computeFilesBySource(components));
        return results;
    }

    public Map<KPI, Map<String, Number>> computeFileAggregatedKpis(String bomId) {
        HashMap<KPI, Map<String, Number>> results = new HashMap<KPI, Map<String, Number>>();
        Collection files = this.fileDao.findByBom(bomId);
        results.put(KPI.files_top10Extensions, this.computeTop10Extensions(files));
        return results;
    }

    public Map<String, Number> computeLicenseKPIForPolicyChange(String bomId) {
        Collection components = this.componentDao.findBomComponents(bomId);
        return this.computeComponentsCompliance(bomId, components);
    }

    public Map<String, Number> computeVulnerabilityKPIForVulnerabilityChange(String bomId) {
        Collection components = this.componentDao.findBomComponents(bomId);
        return this.computeComponentsVulnerabilities(components);
    }

    private Map<String, Number> computeTop10Values(Collection<BomComponentVertex> components, Function<BomComponentVertex, List<String>> fieldExtractor) {
        AtomicInteger limit = new AtomicInteger(0);
        LinkedHashMap<String, Number> top10Result = new LinkedHashMap<String, Number>();
        HashMap temporaryTotal = new HashMap();
        components.stream().flatMap(c -> ((List)fieldExtractor.apply((BomComponentVertex)c)).stream()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).peek(e -> temporaryTotal.put((String)e.getKey(), (Long)e.getValue())).forEachOrdered(e -> {
            if (limit.getAndAdd(1) < 10) {
                top10Result.put((String)e.getKey(), (Number)e.getValue());
            }
        });
        Long sumOther = temporaryTotal.entrySet().stream().filter(e -> !top10Result.containsKey(e.getKey())).map(Map.Entry::getValue).reduce(0L, Long::sum);
        if (sumOther > 0L) {
            top10Result.put("Others", sumOther);
        }
        return top10Result;
    }

    private Map<String, Number> computeComponentsCompliance(String bomId, Collection<BomComponentVertex> components) {
        Map<String, ComplianceLevel> complianceMap = this.licenseDao.findBomLicenses(bomId).stream().collect(Collectors.toMap(LicenseVertex::getSpdxId, BomLicenseVertex::getComplianceLevel));
        AtomicLong noLicense = new AtomicLong(0L);
        Map<String, Number> byCompliance = components.stream().peek(c -> noLicense.addAndGet(c.getLicenses().isEmpty() ? 1L : 0L)).map(BomComponentVertex::getLicenses).map(cl -> this.getMaxLicenseCompliance(cl, complianceMap)).filter(Objects::nonNull).collect(Collectors.groupingBy(Enum::name, Collectors.reducing(0, e -> 1, (e1, e2) -> e1.longValue() + e2.longValue())));
        if (noLicense.get() > 0L) {
            byCompliance.put("NOLICENSE", noLicense.get());
        }
        return byCompliance;
    }

    private Map<String, Number> computeComponentsVulnerabilities(Collection<BomComponentVertex> components) {
        HashMap<String, Number> byVulnerabilities = new HashMap<String, Number>();
        byVulnerabilities.put(VulnerabilityLevel.CRITICAL.name(), 0);
        byVulnerabilities.put(VulnerabilityLevel.HIGH.name(), 0);
        byVulnerabilities.put(VulnerabilityLevel.MEDIUM.name(), 0);
        byVulnerabilities.put(VulnerabilityLevel.LOW.name(), 0);
        byVulnerabilities.put(VulnerabilityLevel.NONE.name(), 0);
        byVulnerabilities.put(VulnerabilityLevel.UNKNOWN.name(), 0);
        ArrayList distinctVIds = new ArrayList();
        components.forEach(c -> c.getVulnerabilities().forEach(v -> {
            for (String severity : byVulnerabilities.keySet()) {
                if (!severity.equals(v.getSeverity()) || distinctVIds.contains(v.getVId())) continue;
                distinctVIds.add(v.getVId());
                byVulnerabilities.put(severity, ((Number)byVulnerabilities.get(severity)).longValue() + 1L);
                break;
            }
        }));
        byVulnerabilities.put(VulnerabilityLevel.NONE.name(), components.size() - distinctVIds.size());
        return byVulnerabilities;
    }

    private Map<String, Number> computeComponentsObsolescence(Collection<BomComponentVertex> components) {
        Map<String, Number> byObsolescence = components.stream().collect(Collectors.groupingBy(ComponentVertex::getUpToDate, Collectors.reducing(0, e -> 1, (e1, e2) -> e1.longValue() + e2.longValue())));
        Stream.of(ObsolescenceLevel.values()).filter(Predicates.negate(o -> byObsolescence.containsKey(o.name()))).forEach(c -> byObsolescence.put(c.name(), 0L));
        return byObsolescence;
    }

    private Map<String, Number> computeFilesBySource(Collection<BomComponentVertex> components) {
        return components.stream().collect(Collectors.groupingBy(ComponentVertex::getSource, Collectors.reducing(0, ComponentVertex::countFiles, (e1, e2) -> e1.longValue() + e2.longValue())));
    }

    private Map<String, Number> computeTop10Extensions(Collection<FileVertex> files) {
        AtomicInteger limit = new AtomicInteger(0);
        LinkedHashMap<String, Number> top10Result = new LinkedHashMap<String, Number>();
        HashMap temporaryTotal = new HashMap();
        files.stream().map(NamedVertex::getName).map(s -> s.lastIndexOf(46) < 1 ? "none" : s.substring(s.lastIndexOf(46) + 1)).map(String::toLowerCase).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).peek(e -> temporaryTotal.put((String)e.getKey(), (Long)e.getValue())).forEachOrdered(e -> {
            if (limit.getAndAdd(1) < 10) {
                top10Result.put((String)e.getKey(), (Number)e.getValue());
            }
        });
        Long sumOther = temporaryTotal.entrySet().stream().filter(e -> !top10Result.containsKey(e.getKey())).map(Map.Entry::getValue).reduce(0L, Long::sum);
        if (sumOther > 0L) {
            top10Result.put("Others", sumOther);
        }
        return top10Result;
    }

    private ComplianceLevel getMaxLicenseCompliance(Collection<LicenseVertex> licenses, Map<String, ComplianceLevel> complianceMap) {
        List levels = licenses.stream().map(l -> Optional.ofNullable((ComplianceLevel)complianceMap.get(l.getSpdxId())).map(Enum::name).orElse(ComplianceLevel.UNKNOWN.name())).distinct().collect(Collectors.toList());
        if (levels.isEmpty()) {
            return null;
        }
        return levels.contains(ComplianceLevel.NO.name()) ? ComplianceLevel.NO : (levels.contains(ComplianceLevel.CONDITIONAL.name()) ? ComplianceLevel.CONDITIONAL : (levels.contains(ComplianceLevel.YES.name()) ? ComplianceLevel.YES : ComplianceLevel.UNKNOWN));
    }

    private VulnerabilityLevel getMaxVulnerabilityLevel(Collection<VulnerabilityVertex> vulnerabilities) {
        List levels = vulnerabilities.stream().map(VulnerabilityVertex::getSeverity).distinct().collect(Collectors.toList());
        if (levels.isEmpty()) {
            return null;
        }
        return levels.contains(VulnerabilityLevel.CRITICAL.name()) ? VulnerabilityLevel.CRITICAL : (levels.contains(VulnerabilityLevel.HIGH.name()) ? VulnerabilityLevel.HIGH : (levels.contains(VulnerabilityLevel.MEDIUM.name()) ? VulnerabilityLevel.MEDIUM : (levels.contains(VulnerabilityLevel.LOW.name()) ? VulnerabilityLevel.LOW : (levels.contains(VulnerabilityLevel.NONE.name()) ? VulnerabilityLevel.NONE : VulnerabilityLevel.UNKNOWN))));
    }
}

