/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.kpi.domain;

import com.castsoftware.sca.scar.server.kpi.domain.KPI;
import com.castsoftware.sca.scar.server.kpi.structure.KPIClassDefinition;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.orientdb.structure.VClassDefinition;
import com.castsoftware.sca.scar.server.util.visitable.SCArVertexVisitor;
import com.orientechnologies.orient.core.record.impl.OVertexDocument;
import java.util.Map;
import java.util.Optional;

public class KPIVertex
extends Vertex<SCArVertexVisitor> {
    public KPIVertex() {
    }

    public KPIVertex(OVertexDocument vertex) {
        super(vertex);
    }

    public VClassDefinition definition() {
        return KPIClassDefinition.V.VKPI;
    }

    public <VALUE extends Number> void addKPI(KPI kpi, VALUE value) {
        this.setProperty(kpi.name(), value);
    }

    public <VALUE extends Number> VALUE getKPI(KPI kpi, VALUE defaultValue) {
        Optional.ofNullable(kpi).orElseThrow(IllegalArgumentException::new);
        return (VALUE)((Number)this.getProperty(kpi.name(), defaultValue));
    }

    public <VALUE extends Map<String, Number>> void addAggregatedKPI(KPI kpi, VALUE value) {
        this.setProperty(kpi.name(), value);
    }

    public <VALUE extends Map<String, Number>> VALUE getAggregatedKPI(KPI kpi, VALUE defaultValue) {
        Optional.ofNullable(kpi).orElseThrow(IllegalArgumentException::new);
        return (VALUE)((Map)this.getProperty(kpi.name(), defaultValue));
    }

    public void accept(SCArVertexVisitor visitor) {
        visitor.visit(this);
    }
}

