/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.global.service;

import com.castsoftware.sca.scar.server.bom.dao.BomDao;
import com.castsoftware.sca.scar.server.bom.model.BomView;
import com.castsoftware.sca.scar.server.bom.transformer.Boms;
import com.castsoftware.sca.scar.server.global.model.FieldSelector;
import com.castsoftware.sca.scar.server.global.model.GlobalKPIView;
import com.castsoftware.sca.scar.server.license.dao.LicenseDao;
import com.castsoftware.sca.scar.server.license.dao.LicensePolicyDao;
import com.castsoftware.sca.scar.server.vulnerability.dao.VulnerabilityDao;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GlobalService {
    private static final int MAX_BOMS = 5;
    private final BomDao bomDao;
    private final LicenseDao licenseDao;
    private final LicensePolicyDao licensePolicyDao;
    private final VulnerabilityDao vulnerabilityDao;

    public GlobalService(BomDao bomDao, LicenseDao licenseDao, LicensePolicyDao licensePolicyDao, VulnerabilityDao vulnerabilityDao) {
        this.bomDao = bomDao;
        this.licenseDao = licenseDao;
        this.licensePolicyDao = licensePolicyDao;
        this.vulnerabilityDao = vulnerabilityDao;
    }

    public GlobalKPIView getGlobalKPIs() {
        return new GlobalKPIView(this.bomDao.countAll().orElse(0L), this.licenseDao.count(), this.licensePolicyDao.count(), this.vulnerabilityDao.count());
    }

    public List<BomView> getLatestBoms(@NonNull FieldSelector fieldSelector) {
        return this.bomDao.findByDateLimit(fieldSelector.getField(), 5).stream().map(Boms::from).collect(Collectors.toList());
    }
}

