/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.cyclonedx.exporter;

import com.castsoftware.sca.scar.server.util.Fields;
import com.castsoftware.sca.scar.server.vulnerability.domain.ScoreType;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityType;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityVertex;
import com.castsoftware.sca.scar.server.vulnerability.dto.VulnerabilityView;
import com.castsoftware.sca.util.java.Opt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cyclonedx.model.vulnerability.Vulnerability;

public class CdxVulnerabilityExporter {
    public static final String BASE_URL_NVD = "https://nvd.nist.gov/vuln/detail/";
    public static final String NVD = "NVD";
    public static final String UNDEFINED = "UNDEFINED";
    private static final String CVSS3_IMPACT = "CVSS3 IMPACT";
    private static final String CVSS3_EXPLOIT = "CVSS3 EXPLOITABILITY";
    private static final String CVSS2_IMPACT = "CVSS2 IMPACT";
    private static final String CVSS2_EXPLOIT = "CVSS2 EXPLOITABILITY";

    public Vulnerability extractVulnerability(@NonNull VulnerabilityView vulnerability, VulnerabilityVertex vulnerabilityVertex, String bomRef) {
        String vulId = vulnerability.getVulId();
        String type = vulnerability.getType();
        Vulnerability cdxVulnerability = new Vulnerability();
        cdxVulnerability.setId(vulId);
        cdxVulnerability.setBomRef(vulId);
        Vulnerability.Affect affectedComponent = new Vulnerability.Affect();
        affectedComponent.setRef(bomRef);
        cdxVulnerability.setAffects(new ArrayList());
        cdxVulnerability.getAffects().add(affectedComponent);
        cdxVulnerability.setSource(this.createSource(type, vulId));
        if (vulnerabilityVertex != null) {
            cdxVulnerability.setSource(this.createSource(vulnerabilityVertex.getType(), vulId));
            Opt.ofEmptyCollection((Collection)vulnerabilityVertex.getCwes()).map(cwes -> cwes.stream().filter(cwe -> !cwe.matches("[a-zA-Z]+")).map(cwe -> Integer.parseInt(cwe.replaceAll("[^0-9]", ""))).collect(Collectors.toList())).ifPresent(arg_0 -> ((Vulnerability)cdxVulnerability).setCwes(arg_0));
            Opt.ofEmptyCollection((Collection)vulnerabilityVertex.getReferences()).map(refs -> refs.stream().map(ref -> {
                Vulnerability.Source vSource = new Vulnerability.Source();
                vSource.setUrl(ref);
                Vulnerability.Reference vRef = new Vulnerability.Reference();
                vRef.setId(vulId);
                vRef.setSource(vSource);
                return vRef;
            }).collect(Collectors.toList())).ifPresent(arg_0 -> ((Vulnerability)cdxVulnerability).setReferences(arg_0));
            Opt.ofNullable((Object)vulnerabilityVertex.getPublished()).map(Date::from).ifPresent(arg_0 -> ((Vulnerability)cdxVulnerability).setPublished(arg_0));
            Fields.field((String)vulnerabilityVertex.getDescription(), arg_0 -> ((Vulnerability)cdxVulnerability).setDescription(arg_0));
            Map scores2 = vulnerabilityVertex.getScores2();
            Map scores3 = vulnerabilityVertex.getScores3();
            if (MapUtils.isNotEmpty((Map)scores2) || MapUtils.isNotEmpty((Map)scores3)) {
                StringJoiner analysisTextJoiner = new StringJoiner(", ");
                this.joinScoreAttribute(analysisTextJoiner, scores2, ScoreType.IMPACT, CVSS2_IMPACT);
                this.joinScoreAttribute(analysisTextJoiner, scores2, ScoreType.EXPLOITABILITY, CVSS2_EXPLOIT);
                this.joinScoreAttribute(analysisTextJoiner, scores3, ScoreType.IMPACT, CVSS3_IMPACT);
                this.joinScoreAttribute(analysisTextJoiner, scores3, ScoreType.EXPLOITABILITY, CVSS3_EXPLOIT);
                Vulnerability.Analysis vAnalysis = new Vulnerability.Analysis();
                String analysisText = analysisTextJoiner.toString();
                if (StringUtils.isNotEmpty((CharSequence)analysisText)) {
                    vAnalysis.setDetail(analysisText);
                }
                cdxVulnerability.setAnalysis(vAnalysis);
            }
            cdxVulnerability.setRatings(new ArrayList());
            if (VulnerabilityType.CVE.name().equals(vulnerabilityVertex.getType())) {
                if (MapUtils.isNotEmpty((Map)scores3)) {
                    Vulnerability.Rating.Method method = Vulnerability.Rating.Method.CVSSV3;
                    if (vulnerabilityVertex.getVector3().contains("CVSS:3.1/")) {
                        method = Vulnerability.Rating.Method.CVSSV31;
                    }
                    Vulnerability.Rating cvss3Rating = this.createRating(vulnerabilityVertex.getSeverity(), method, vulId, vulnerabilityVertex.getType());
                    Double cvss3Score = (Double)vulnerabilityVertex.getScores3().get(ScoreType.BASE.name());
                    cvss3Rating.setScore(cvss3Score);
                    cvss3Rating.setVector(vulnerabilityVertex.getVector3());
                    cdxVulnerability.getRatings().add(cvss3Rating);
                }
                if (MapUtils.isNotEmpty((Map)scores2)) {
                    Vulnerability.Rating cvss2Rating = this.createRating(vulnerabilityVertex.getSeverity(), Vulnerability.Rating.Method.CVSSV2, vulId, vulnerabilityVertex.getType());
                    Double cvss2Score = (Double)vulnerabilityVertex.getScores2().get(ScoreType.BASE.name());
                    cvss2Rating.setScore(cvss2Score);
                    cvss2Rating.setVector(vulnerabilityVertex.getVector2());
                    cdxVulnerability.getRatings().add(cvss2Rating);
                }
            }
        }
        return cdxVulnerability;
    }

    private void joinScoreAttribute(StringJoiner analysisText, Map<String, Double> scores, ScoreType type, String label) {
        if (scores.containsKey(type.name()) && scores.get(type.name()) != null) {
            analysisText.add(new StringJoiner("").add(label).add(":").add(scores.get(type.name()).toString()).toString());
        }
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Vulnerability.Source createSource(String type, String vulId) {
        Vulnerability.Source vSource = new Vulnerability.Source();
        Optional<String> source = Optional.ofNullable(type).filter(VulnerabilityType.CVE.name()::equals).map(t -> {
            vSource.setUrl(BASE_URL_NVD + vulId);
            return NVD;
        });
        vSource.setName(source.orElse(UNDEFINED));
        return vSource;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Vulnerability.Rating createRating(String severity, Vulnerability.Rating.Method method, String vulId, String type) {
        Vulnerability.Rating rating = new Vulnerability.Rating();
        rating.setMethod(method);
        Opt.ofBlankString((String)severity).filter(s -> Vulnerability.Rating.Method.CVSSV3.equals((Object)method)).flatMap(s -> Opt.ofNullable((Object)((Vulnerability.Rating.Severity)EnumUtils.getEnum(Vulnerability.Rating.Severity.class, (String)s.toUpperCase())))).ifPresent(arg_0 -> ((Vulnerability.Rating)rating).setSeverity(arg_0));
        rating.setSource(this.createSource(type, vulId.toUpperCase()));
        return rating;
    }
}

