/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.cyclonedx.exporter;

import com.castsoftware.sca.scar.server.cyclonedx.domain.CdxMetadataProperty;
import com.castsoftware.sca.scar.server.cyclonedx.domain.CdxProperty;
import com.castsoftware.sca.scar.server.cyclonedx.exporter.CdxExportContext;
import com.castsoftware.sca.scar.server.cyclonedx.utils.CdxPropertyUtils;
import com.castsoftware.sca.scar.server.util.Fields;
import com.castsoftware.sca.util.java.Opt;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.License;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.model.OrganizationalEntity;
import org.cyclonedx.model.Service;
import org.cyclonedx.model.license.Expression;
import org.cyclonedx.model.metadata.ToolInformation;

public class CdxMetadataExporter {
    public static final String SCA_TOOL_NAME = "SBOM Manager";
    public static final String VENDOR = "CAST";
    public static final String SERVICE_NAME = "Export BOM";

    public Metadata extractMetadata(@NonNull CdxExportContext context) {
        Metadata metadata = new Metadata();
        ToolInformation toolInfo = new ToolInformation();
        Component tool = new Component();
        tool.setVersion(context.getScarVersion());
        tool.setName(SCA_TOOL_NAME);
        tool.setType(Component.Type.APPLICATION);
        OrganizationalEntity vendor = new OrganizationalEntity();
        vendor.setName(VENDOR);
        tool.setSupplier(vendor);
        toolInfo.setComponents(List.of(tool));
        Service service = new Service();
        service.setName(SERVICE_NAME);
        toolInfo.setServices(List.of(service));
        metadata.setToolChoice(toolInfo);
        OrganizationalEntity manufacture = new OrganizationalEntity();
        manufacture.setName(context.getProject());
        metadata.setManufacture(manufacture);
        Opt.ofNullable((Object)context.getCreated()).map(Date::from).ifPresent(arg_0 -> ((Metadata)metadata).setTimestamp(arg_0));
        Opt.ofNullable((Object)context.getProduct()).map(_p -> this.createMetadataComponent(context)).ifPresent(arg_0 -> ((Metadata)metadata).setComponent(arg_0));
        Opt.ofNullable((Object)context.getLicensePolicy()).filter(StringUtils::isNotBlank).map(pn -> Opt.ofEmptyCollection((Collection)context.getValidSpxdIds()).filter(ids -> ids.contains(pn)).map(_ids -> {
            License license = new License();
            license.setId(pn);
            LicenseChoice licenseChoice = new LicenseChoice();
            licenseChoice.setLicenses(List.of(license));
            return licenseChoice;
        }).orElseGet(() -> {
            LicenseChoice licenseChoice = new LicenseChoice();
            licenseChoice.setExpression(new Expression(pn));
            return licenseChoice;
        })).ifPresent(arg_0 -> ((Metadata)metadata).setLicenseChoice(arg_0));
        return metadata;
    }

    private @NonNull Component createMetadataComponent(@NonNull CdxExportContext context) {
        Component component = new Component();
        component.setType(Component.Type.APPLICATION);
        Fields.field((String)context.getProduct(), arg_0 -> ((Component)component).setName(arg_0));
        Fields.field((String)context.getVersion(), arg_0 -> ((Component)component).setVersion(arg_0));
        CdxPropertyUtils.cdxPropField((String)context.getReviewStep(), (CdxProperty)CdxMetadataProperty.REVIEW_STEP, (Component)component);
        CdxPropertyUtils.cdxPropField((String)context.getSourcePath(), (CdxProperty)CdxMetadataProperty.SOURCE_PATH, (Component)component);
        return component;
    }
}

