/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.cyclonedx.exporter;

import com.castsoftware.sca.scar.server.license.model.LightLicenseView;
import com.castsoftware.sca.scar.server.util.Fields;
import com.castsoftware.sca.util.java.Opt;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cyclonedx.model.AttachmentText;
import org.cyclonedx.model.License;
import org.cyclonedx.model.LicenseChoice;

public class CdxLicenseExporter {
    private final Set<String> validSpdxIds;

    public CdxLicenseExporter(Set<String> validSpdxIds) {
        this.validSpdxIds = validSpdxIds;
    }

    public @NonNull LicenseChoice extractCdxLicenses(@NonNull Collection<LightLicenseView> licenses) {
        return Opt.ofEmptyCollection(licenses).map(ls -> ls.stream().map(arg_0 -> this.extractCdxLicense(arg_0)).collect(Collectors.toList())).map(ls -> {
            LicenseChoice licenseChoice = new LicenseChoice();
            licenseChoice.setLicenses(ls);
            return licenseChoice;
        }).orElse(new LicenseChoice());
    }

    private @NonNull License extractCdxLicense(@NonNull LightLicenseView license) {
        License cdxLicence = new License();
        String spdxId = license.getSpdxId();
        if (StringUtils.isNotBlank((CharSequence)spdxId) && this.validSpdxIds.contains(spdxId)) {
            Fields.field((String)spdxId, arg_0 -> ((License)cdxLicence).setId(arg_0));
        } else {
            Opt.ofBlankString((String)spdxId).or(() -> Opt.ofBlankString((String)license.getTitle())).ifPresent(arg_0 -> ((License)cdxLicence).setName(arg_0));
        }
        if (StringUtils.isNotBlank((CharSequence)license.getDescription())) {
            AttachmentText text = new AttachmentText();
            text.setText(license.getDescription());
            cdxLicence.setLicenseText(text);
        }
        return cdxLicence;
    }
}

