/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.cyclonedx.exporter;

import com.castsoftware.sca.scar.server.component.model.ComponentView;
import com.castsoftware.sca.scar.server.cyclonedx.domain.CdxLibraryProperty;
import com.castsoftware.sca.scar.server.cyclonedx.domain.CdxProperty;
import com.castsoftware.sca.scar.server.cyclonedx.exporter.CdxLicenseExporter;
import com.castsoftware.sca.scar.server.cyclonedx.utils.CdxPropertyUtils;
import com.castsoftware.sca.scar.server.util.Fields;
import com.castsoftware.sca.util.java.Opt;
import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ExternalReference;

public class CdxLibraryExporter {
    private static final String MAVEN_REPO_TYPE = "MAVEN";
    private final CdxLicenseExporter licenseExporter;

    public CdxLibraryExporter(CdxLicenseExporter licenseExporter) {
        this.licenseExporter = licenseExporter;
    }

    public Component extractCdxComponent(@NonNull ComponentView component, boolean isFullExport) {
        Component cdxComponent = new Component();
        cdxComponent.setType(Component.Type.LIBRARY);
        Fields.field((String)component.getName(), arg_0 -> ((Component)cdxComponent).setName(arg_0));
        Opt.ofBlankString((String)component.getName()).filter(name -> name.contains("/")).map(name -> name.split("/", 2)[0]).ifPresent(arg_0 -> ((Component)cdxComponent).setAuthor(arg_0));
        Fields.field((String)component.getDescription(), arg_0 -> ((Component)cdxComponent).setDescription(arg_0));
        Opt.ofBlankString((String)component.getVersion()).map(version -> cdxComponent.getName() + "@" + version).ifPresentOrElse(arg_0 -> ((Component)cdxComponent).setBomRef(arg_0), () -> cdxComponent.setBomRef(cdxComponent.getName()));
        Opt.ofBlankString((String)component.getVersion()).ifPresent(arg_0 -> ((Component)cdxComponent).setVersion(arg_0));
        CdxPropertyUtils.cdxPropField((String)component.getCategory(), (CdxProperty)CdxLibraryProperty.CATEGORY, (Component)cdxComponent);
        CdxPropertyUtils.cdxPropField((String)component.getUpToDate(), (CdxProperty)CdxLibraryProperty.OBSOLESCENCE, (Component)cdxComponent);
        CdxPropertyUtils.cdxPropField((String)component.getScaId(), (CdxProperty)CdxLibraryProperty.SCA_ID, (Component)cdxComponent);
        Opt.ofEmptyCollection((Collection)component.getReferences()).map(rs -> rs.stream().map(ref -> {
            ExternalReference extRef = new ExternalReference();
            extRef.setUrl(ref);
            extRef.setType(ExternalReference.Type.DOCUMENTATION);
            return extRef;
        }).collect(Collectors.toList())).ifPresent(arg_0 -> ((Component)cdxComponent).setExternalReferences(arg_0));
        Fields.field((String)component.getCopyright(), arg_0 -> ((Component)cdxComponent).setCopyright(arg_0));
        if (isFullExport) {
            CdxPropertyUtils.cdxPropField((String)component.getLatestVersion(), (CdxProperty)CdxLibraryProperty.LATEST_VERSION, (Component)cdxComponent);
            Opt.ofEmptyCollection((Collection)component.getAllVersions()).flatMap(versions -> versions.stream().map(version -> version.getName() + ":" + version.getTimestamp()).reduce((v1, v2) -> v1 + ", " + v2)).ifPresent(vs -> CdxPropertyUtils.cdxPropField((String)vs, (CdxProperty)CdxLibraryProperty.ALL_VERSIONS, (Component)cdxComponent));
            CdxPropertyUtils.cdxPropField((String)component.getSource(), (CdxProperty)CdxLibraryProperty.SOURCE, (Component)cdxComponent);
            CdxPropertyUtils.cdxPropField((String)component.getRepository(), (CdxProperty)CdxLibraryProperty.REPOSITORY, (Component)cdxComponent);
            CdxPropertyUtils.cdxPropField((String)component.getRepositoryType(), (CdxProperty)CdxLibraryProperty.REPOSITORY_TYPE, (Component)cdxComponent);
            CdxPropertyUtils.cdxPropField((String)component.getPath(), (CdxProperty)CdxLibraryProperty.PATH, (Component)cdxComponent);
            CdxPropertyUtils.cdxPropField((String)component.getCounter().getFiles().toString(), (CdxProperty)CdxLibraryProperty.FILE_COUNT, (Component)cdxComponent);
            CdxPropertyUtils.cdxPropField((String)component.getComments(), (CdxProperty)CdxLibraryProperty.COMMENTS, (Component)cdxComponent);
            Opt.ofEmptyCollection((Collection)component.getLanguages()).map(ls -> StringUtils.join((Iterable)ls, (String)", ")).ifPresent(ls -> CdxPropertyUtils.cdxPropField((String)ls, (CdxProperty)CdxLibraryProperty.LANGUAGES, (Component)cdxComponent));
            Opt.ofEmptyCollection((Collection)component.getTopics()).map(ts -> StringUtils.join((Iterable)ts, (String)", ")).ifPresent(ls -> CdxPropertyUtils.cdxPropField((String)ls, (CdxProperty)CdxLibraryProperty.TOPICS, (Component)cdxComponent));
            CdxPropertyUtils.cdxPropField((String)component.getDeclaredBy(), (CdxProperty)CdxLibraryProperty.DECLARED_BY, (Component)cdxComponent);
            this.extractPUrl(component.getName(), component.getRepositoryType(), component.getVersion()).ifPresent(arg_0 -> ((Component)cdxComponent).setPurl(arg_0));
        }
        Opt.of((Object)component.getLicenses()).map(arg_0 -> ((CdxLicenseExporter)this.licenseExporter).extractCdxLicenses(arg_0)).ifPresent(arg_0 -> ((Component)cdxComponent).setLicenseChoice(arg_0));
        return cdxComponent;
    }

    private Optional<PackageURL> extractPUrl(String name, String repositoryType, String version) {
        String[] stringArray;
        if (StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)repositoryType)) {
            return Optional.empty();
        }
        if (MAVEN_REPO_TYPE.equals(repositoryType) && name.contains(":")) {
            stringArray = name.split(":");
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = null;
            stringArray = stringArray2;
            stringArray2[1] = name;
        }
        String[] nameSplit = stringArray;
        String namespace = nameSplit[0];
        String packageName = nameSplit[1];
        if (!MAVEN_REPO_TYPE.equals(repositoryType) || !StringUtils.isBlank((CharSequence)namespace)) {
            try {
                return Opt.of((Object)new PackageURL(repositoryType.toLowerCase(), namespace, packageName, version, null, null));
            }
            catch (MalformedPackageURLException malformedPackageURLException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }
}

