/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.cyclonedx.exporter;

import com.castsoftware.sca.scar.server.bom.model.FileView;
import com.castsoftware.sca.scar.server.cyclonedx.domain.CdxFileProperty;
import com.castsoftware.sca.scar.server.cyclonedx.domain.CdxProperty;
import com.castsoftware.sca.scar.server.cyclonedx.exporter.CdxLicenseExporter;
import com.castsoftware.sca.scar.server.cyclonedx.utils.CdxPropertyUtils;
import com.castsoftware.sca.scar.server.util.Fields;
import com.castsoftware.sca.util.java.Opt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Hash;

/*
 * Exception performing whole class analysis ignored.
 */
public class CdxFileExporter {
    private final CdxLicenseExporter cdxLicenseExporter;

    public CdxFileExporter(CdxLicenseExporter cdxLicenseExporter) {
        this.cdxLicenseExporter = cdxLicenseExporter;
    }

    public Component extractCdxFile(FileView file, boolean isFullExport) {
        Component cdxFile = new Component();
        cdxFile.setType(Component.Type.FILE);
        cdxFile.setBomRef(String.format("%s%s@%s", file.getName(), Opt.ofBlankString((String)file.getVersion()).map(v -> "@" + v).orElse(""), UUID.randomUUID()));
        Fields.field((String)file.getName(), arg_0 -> ((Component)cdxFile).setName(arg_0));
        Fields.field((String)file.getComments(), arg_0 -> ((Component)cdxFile).setDescription(arg_0));
        Fields.field((String)file.getVersion(), arg_0 -> ((Component)cdxFile).setVersion(arg_0));
        Fields.field((String)file.getCopyright(), arg_0 -> ((Component)cdxFile).setCopyright(arg_0));
        CdxFileExporter.addCdxFileHash((String)file.getMd5(), (Hash.Algorithm)Hash.Algorithm.MD5, (Component)cdxFile);
        CdxFileExporter.addCdxFileHash((String)file.getSha1(), (Hash.Algorithm)Hash.Algorithm.SHA1, (Component)cdxFile);
        CdxFileExporter.addCdxFileHash((String)file.getSha256(), (Hash.Algorithm)Hash.Algorithm.SHA_256, (Component)cdxFile);
        cdxFile.setProperties(new ArrayList());
        if (isFullExport) {
            CdxPropertyUtils.cdxPropField((String)file.getPath(), (CdxProperty)CdxFileProperty.PATH, (Component)cdxFile);
            Opt.ofBlankString((String)file.getName()).map(FilenameUtils::getExtension).filter(StringUtils::isNotBlank).ifPresent(e -> CdxPropertyUtils.cdxPropField((String)e, (CdxProperty)CdxFileProperty.EXTENSION, (Component)cdxFile));
            Opt.ofNullable((Object)file.getSize()).map(Object::toString).ifPresent(s -> CdxPropertyUtils.cdxPropField((String)s, (CdxProperty)CdxFileProperty.SIZE, (Component)cdxFile));
        }
        Opt.ofEmptyCollection((Collection)file.getLicenses()).map(arg_0 -> ((CdxLicenseExporter)this.cdxLicenseExporter).extractCdxLicenses(arg_0)).ifPresent(arg_0 -> ((Component)cdxFile).setLicenseChoice(arg_0));
        return cdxFile;
    }

    private static void addCdxFileHash(String hash, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Hash.Algorithm algorithm, @NonNull Component cdxFile) {
        Opt.ofBlankString((String)hash).map(h -> new Hash(algorithm, h)).ifPresent(h -> {
            if (cdxFile.getHashes() == null) {
                cdxFile.setHashes(new ArrayList());
            }
            cdxFile.getHashes().add(h);
        });
    }
}

