/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.cyclonedx.exporter;

import com.castsoftware.sca.scar.server.bom.domain.BomExportConfiguration;
import com.castsoftware.sca.scar.server.bom.domain.BomExportData;
import com.castsoftware.sca.scar.server.bom.handler.BomExporterEvents;
import com.castsoftware.sca.scar.server.component.model.ComponentView;
import com.castsoftware.sca.scar.server.cyclonedx.exporter.CdxExportContext;
import com.castsoftware.sca.scar.server.cyclonedx.exporter.CdxFileExporter;
import com.castsoftware.sca.scar.server.cyclonedx.exporter.CdxLibraryExporter;
import com.castsoftware.sca.scar.server.cyclonedx.exporter.CdxMetadataExporter;
import com.castsoftware.sca.scar.server.cyclonedx.exporter.CdxVulnerabilityExporter;
import com.castsoftware.sca.scar.server.util.event.Event;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityVertex;
import com.castsoftware.sca.util.java.Opt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.vulnerability.Vulnerability;

public class CdxBomExporter {
    private final CdxMetadataExporter cdxMetadataExporter;
    private final CdxLibraryExporter cdxLibraryExporter;
    private final CdxFileExporter cdxFileExporter;
    private final CdxVulnerabilityExporter cdxVulnerabilityExporter;
    private final Function<String, Optional<VulnerabilityVertex>> vulnerabilityLookup;

    public Bom extractCdxBom(@NonNull CdxExportContext context) {
        BomExportConfiguration config = context.getConfiguration();
        Bom cdxBom = new Bom();
        cdxBom.setMetadata(this.cdxMetadataExporter.extractMetadata(context));
        cdxBom.setSerialNumber("urn:uuid:" + String.valueOf(UUID.randomUUID()));
        cdxBom.setVulnerabilities(new ArrayList());
        Opt.ofEmptyCollection((Collection)context.getComponents()).filter(_components -> config.isExportComponents()).ifPresent(components -> {
            this.notifyStart(context);
            List cdxComponents = components.stream().filter(component -> config.getExportCategories().stream().anyMatch(component.getCategory()::equalsIgnoreCase)).map(component -> this.extractComponent(component, cdxBom, context)).collect(Collectors.toList());
            cdxBom.setComponents(cdxComponents);
        });
        return cdxBom;
    }

    private Component extractComponent(ComponentView component, Bom cdxBom, CdxExportContext context) {
        this.notifyProgress(context);
        boolean isFullExport = BomExportData.FULL.equals((Object)context.getConfiguration().getExportData());
        boolean exportFiles = context.getConfiguration().isExportFiles();
        Component cdxComponent = this.cdxLibraryExporter.extractCdxComponent(component, isFullExport);
        if (CollectionUtils.isNotEmpty((Collection)component.getVulnerabilities())) {
            component.getVulnerabilities().forEach(vulnerability -> this.findExistingVulnerability(vulnerability.getVulId(), cdxBom).ifPresentOrElse(existing -> {
                Vulnerability.Affect affectedComponent = new Vulnerability.Affect();
                affectedComponent.setRef(cdxComponent.getBomRef());
                existing.getAffects().add(affectedComponent);
            }, () -> {
                VulnerabilityVertex vertex = ((Optional)this.vulnerabilityLookup.apply(vulnerability.getVulId())).orElse(null);
                Vulnerability cdxVulnerability = this.cdxVulnerabilityExporter.extractVulnerability(vulnerability, vertex, cdxComponent.getBomRef());
                cdxBom.getVulnerabilities().add(cdxVulnerability);
            }));
        }
        if (exportFiles) {
            component.getFiles().forEach(file -> {
                context.notify((Event)BomExporterEvents.exportComponentOrFile());
                cdxComponent.addComponent(this.cdxFileExporter.extractCdxFile(file, isFullExport));
            });
        }
        return cdxComponent;
    }

    private Optional<Vulnerability> findExistingVulnerability(String vulId, @NonNull Bom cdxBom) {
        return Opt.ofEmptyCollection((Collection)cdxBom.getVulnerabilities()).flatMap(vs -> vs.stream().filter(existing -> existing.getId().equals(vulId)).findFirst());
    }

    private void notifyStart(@NonNull CdxExportContext context) {
        if (context.getConfiguration().isExportFiles()) {
            context.notify((Event)BomExporterEvents.exportComponentsAndFiles((Long)(context.getFileCount() + context.getComponentCount())));
        } else {
            context.notify((Event)BomExporterEvents.exportCycloneDxComponents((Long)context.getComponentCount()));
        }
    }

    private void notifyProgress(@NonNull CdxExportContext context) {
        if (context.getConfiguration().isExportFiles()) {
            context.notify((Event)BomExporterEvents.exportComponentOrFile());
        } else {
            context.notify((Event)BomExporterEvents.exportComponent());
        }
    }

    @Generated
    public CdxBomExporter(CdxMetadataExporter cdxMetadataExporter, CdxLibraryExporter cdxLibraryExporter, CdxFileExporter cdxFileExporter, CdxVulnerabilityExporter cdxVulnerabilityExporter, Function<String, Optional<VulnerabilityVertex>> vulnerabilityLookup) {
        this.cdxMetadataExporter = cdxMetadataExporter;
        this.cdxLibraryExporter = cdxLibraryExporter;
        this.cdxFileExporter = cdxFileExporter;
        this.cdxVulnerabilityExporter = cdxVulnerabilityExporter;
        this.vulnerabilityLookup = vulnerabilityLookup;
    }
}

