/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.core.validation;

import com.castsoftware.sca.scar.server.core.validation.ValidPassword;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.passay.CharacterData;
import org.passay.CharacterRule;
import org.passay.EnglishCharacterData;
import org.passay.LengthRule;
import org.passay.MessageResolver;
import org.passay.PasswordData;
import org.passay.PasswordValidator;
import org.passay.PropertiesMessageResolver;
import org.passay.RuleResult;
import org.passay.WhitespaceRule;

public class PasswordConstraintValidator
implements ConstraintValidator<ValidPassword, String> {
    public boolean isValid(String password, ConstraintValidatorContext context) {
        Properties props = new Properties();
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("passay.properties");
        props.load(inputStream);
        PropertiesMessageResolver resolver = new PropertiesMessageResolver(props);
        PasswordValidator validator = new PasswordValidator((MessageResolver)resolver, Arrays.asList(new LengthRule(9, Integer.MAX_VALUE), new CharacterRule((CharacterData)EnglishCharacterData.UpperCase, 1), new CharacterRule((CharacterData)EnglishCharacterData.LowerCase, 1), new CharacterRule((CharacterData)EnglishCharacterData.Digit, 1), new CharacterRule((CharacterData)EnglishCharacterData.Special, 1), new WhitespaceRule()));
        RuleResult result = validator.validate(new PasswordData(password));
        if (result.isValid()) {
            return true;
        }
        List messages = validator.getMessages(result);
        String messageTemplate = String.join((CharSequence)",", messages);
        context.buildConstraintViolationWithTemplate(messageTemplate).addConstraintViolation().disableDefaultConstraintViolation();
        return false;
    }
}

