/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.core.validation;

import com.castsoftware.sca.scar.server.core.validation.ConditionalValidation;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ConditionalValidator
implements ConstraintValidator<ConditionalValidation, Object> {
    private String conditionalProperty;
    private String[] requiredProperties;
    private String message;
    private String[] values;

    public void initialize(ConditionalValidation constraint) {
        this.conditionalProperty = constraint.conditionalProperty();
        this.requiredProperties = constraint.requiredProperties();
        this.message = constraint.message();
        this.values = constraint.values();
    }

    public boolean isValid(Object object, ConstraintValidatorContext context) {
        try {
            String conditionalPropertyValue = BeanUtils.getProperty((Object)object, (String)this.conditionalProperty);
            if (this.doConditionalValidation((Object)conditionalPropertyValue)) {
                return this.validateRequiredProperties(object, context);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            return false;
        }
        return true;
    }

    private boolean validateRequiredProperties(Object object, ConstraintValidatorContext context) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        boolean isValid = true;
        for (String property : this.requiredProperties) {
            boolean isPresent;
            String requiredValue = BeanUtils.getProperty((Object)object, (String)property);
            boolean bl = isPresent = requiredValue != null && !ObjectUtils.isEmpty((Object)requiredValue);
            if (isPresent) continue;
            isValid = false;
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(this.message).addPropertyNode(property).addConstraintViolation();
        }
        return isValid;
    }

    private boolean doConditionalValidation(Object actualValue) {
        return Arrays.asList(this.values).contains(actualValue);
    }
}

