/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.core.transformer;

import com.castsoftware.sca.scar.server.core.dao.FindConfiguration;
import com.castsoftware.sca.scar.server.core.dao.PaginationConfiguration;
import com.castsoftware.sca.scar.server.core.dao.SortConfiguration;
import com.castsoftware.sca.scar.server.core.model.SortedView;
import com.castsoftware.sca.scar.server.core.model.request.GetRequest;
import com.castsoftware.sca.util.java.Functions;
import com.castsoftware.sca.util.java.Predicates;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public final class FindConfigurationTransformers {
    public static FindConfiguration from(GetRequest getRequest) {
        FindConfiguration findConfiguration = new FindConfiguration();
        Optional<GetRequest> gr = Optional.ofNullable(getRequest);
        gr.map(GetRequest::getLinkedSort).map(ls -> ls.stream().sorted(Comparator.comparing(SortedView::getOrder)).map(SortedView::getView).collect(Collectors.toCollection(LinkedList::new))).filter(Predicates.notEmptyCollection()).map(SortConfiguration::new).map(Functions.peek(sc -> sc.setAscend(GetRequest.SortDirection.ascend.equals((Object)getRequest.getSortDirection())))).ifPresent(arg_0 -> ((FindConfiguration)findConfiguration).setSort(arg_0));
        gr.filter(r -> r.getLimit() > 0).map(FindConfigurationTransformers::paginationFrom).ifPresent(arg_0 -> ((FindConfiguration)findConfiguration).setPagination(arg_0));
        return findConfiguration;
    }

    public static PaginationConfiguration paginationFrom(GetRequest request) {
        return Optional.of(request).map(GetRequest::getPage).filter(p -> p > 0).map(p -> new PaginationConfiguration(Integer.valueOf(request.getLimit()), Integer.valueOf((p - 1) * request.getLimit()))).orElseGet(() -> new PaginationConfiguration(Integer.valueOf(request.getLimit()), Integer.valueOf(0)));
    }

    @Generated
    private FindConfigurationTransformers() {
    }
}

