/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.core.launcher;

import com.castsoftware.sca.scar.server.autoconfiguration.component.application.NoDestroyLauncher;
import com.castsoftware.sca.scar.server.core.component.ServerStatusHolder;
import com.castsoftware.sca.scar.server.core.db.DatabaseTask;
import com.castsoftware.sca.scar.server.core.db.DatabaseTaskContext;
import com.castsoftware.sca.scar.server.orientdb.EmbeddedServer;
import com.castsoftware.sca.scar.server.orientdb.RemoteDatabasePoolBuilder;
import com.castsoftware.sca.scar.server.orientdb.configuration.UserConfiguration;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import jakarta.annotation.Priority;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;

@Priority(value=50)
public class DatabaseTaskLauncher
extends NoDestroyLauncher {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(DatabaseTaskLauncher.class);
    private static final Pattern CLASSNAME_PATTERN = Pattern.compile("V[1-9][0-9]*_(.)+");
    private final DatabaseTaskContext executionContext;
    private final List<DatabaseTask> databaseTasks;
    private final ServerStatusHolder serverStatusHolder;

    public DatabaseTaskLauncher(RemoteDatabasePoolBuilder databaseBuilder, UserConfiguration rootUserConfig, List<DatabaseTask> databaseTasks, ServerStatusHolder serverStatusHolder, EmbeddedServer embeddedServer) {
        this.executionContext = new DatabaseTaskContext(databaseBuilder, rootUserConfig, embeddedServer);
        this.databaseTasks = databaseTasks;
        this.serverStatusHolder = serverStatusHolder;
    }

    public void launch() throws Exception {
        this.databaseTasks.stream().filter(task -> CLASSNAME_PATTERN.matcher(task.getTaskName()).matches()).sorted(Comparator.comparingInt(arg_0 -> this.extractVersion(arg_0))).forEach(task -> {
            try {
                task.execute(this.executionContext);
            }
            catch (Throwable t) {
                LOGGER.warn(String.format("Unexpected error whilst attempting to run task %s", task.getTaskName()));
                throw t;
            }
        });
        this.serverStatusHolder.setStatus(ServerStatusHolder.ServerStatus.READY);
    }

    private int extractVersion(@NonNull DatabaseTask task) {
        String name = task.getTaskName();
        return Integer.parseInt(name.substring(1, name.indexOf(95)));
    }

    @Generated
    public List<DatabaseTask> getDatabaseTasks() {
        return this.databaseTasks;
    }
}

