/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.core.launcher;

import com.castsoftware.sca.scar.server.autoconfiguration.component.application.NoDestroyLauncher;
import com.castsoftware.sca.scar.server.bom.dao.BomDao;
import com.castsoftware.sca.scar.server.bom.dao.FolderDao;
import com.castsoftware.sca.scar.server.bom.dao.ProductDao;
import com.castsoftware.sca.scar.server.bom.dao.ProjectDao;
import com.castsoftware.sca.scar.server.component.dao.ComponentDao;
import com.castsoftware.sca.scar.server.kpi.dao.KPIDao;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import jakarta.annotation.Priority;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;

@Priority(value=80)
public class DatabasePruningLauncher
extends NoDestroyLauncher {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(DatabasePruningLauncher.class);
    private final BomDao bomDao;
    private final ProductDao productDao;
    private final ProjectDao projectDao;
    private final ComponentDao componentDao;
    private final FolderDao folderDao;
    private final KPIDao kpiDao;

    public DatabasePruningLauncher(BomDao bomDao, ProductDao productDao, ProjectDao projectDao, ComponentDao componentDao, FolderDao folderDao, KPIDao kpiDao) {
        this.bomDao = bomDao;
        this.productDao = productDao;
        this.projectDao = projectDao;
        this.componentDao = componentDao;
        this.folderDao = folderDao;
        this.kpiDao = kpiDao;
    }

    public void launch() throws Exception {
        LOGGER.info("Pruning orphaned SBOMs & Projects...");
        List bomVertices = this.bomDao.findOrphanedBoms();
        if (bomVertices.isEmpty()) {
            LOGGER.info("No orphaned SBOMs found!");
        } else {
            AtomicInteger pruned = new AtomicInteger(0);
            bomVertices.forEach(bomVertex -> {
                String bomId = bomVertex.getId();
                try {
                    this.componentDao.deleteFromBom(bomId);
                    this.folderDao.deleteFromBom(bomId);
                    this.kpiDao.deleteByBom(bomId);
                    this.bomDao.delete((Vertex)bomVertex);
                    pruned.incrementAndGet();
                }
                catch (Exception ex) {
                    LOGGER.error("Unexpected error while pruning the SBOM with id '{}'! Skipping...", (Object)bomVertex.getId(), (Object)ex);
                }
            });
            LOGGER.info("Pruned {} orphaned SBOM{}", (Object)pruned.get(), (Object)(pruned.get() == 1 ? "" : "s"));
        }
        this.projectDao.findEmptyProjects().forEach(arg_0 -> ((ProjectDao)this.projectDao).delete(arg_0));
        this.productDao.findEmptyProducts().forEach(arg_0 -> ((ProductDao)this.productDao).delete(arg_0));
    }
}

