/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.core.db.migration;

import com.castsoftware.sca.scar.server.core.db.DatabaseTask;
import com.castsoftware.sca.scar.server.core.db.DatabaseTaskContext;
import com.castsoftware.sca.scar.server.message.Message;
import com.castsoftware.sca.scar.server.message.MessageRepository;
import com.castsoftware.sca.scar.server.message.MessageSource;
import com.castsoftware.sca.scar.server.message.MessageType;
import com.castsoftware.sca.scar.server.preference.repository.ScannerPreferencesRepository;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;

public class V6_ScannerPreferencesCheck
extends DatabaseTask {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(V6_ScannerPreferencesCheck.class);
    private final MessageRepository messageRepository;
    private final ScannerPreferencesRepository scannerPreferencesRepository;

    public V6_ScannerPreferencesCheck(@NonNull MessageRepository messageRepository, @NonNull ScannerPreferencesRepository scannerPreferencesRepository) {
        this.messageRepository = messageRepository;
        this.scannerPreferencesRepository = scannerPreferencesRepository;
    }

    protected void doExecute(@NonNull DatabaseTaskContext context) {
        LOGGER.info("Checking scanner preferences configuration...");
        if (this.isConfiguredAndValid()) {
            this.messageRepository.deleteMessagesByType(MessageType.SCANNER_CONFIG);
            LOGGER.debug("Scanner properly configured - no message needed");
            return;
        }
        if (this.messageExists()) {
            LOGGER.debug("Scanner config message already exists");
            return;
        }
        LOGGER.info("Creating scanner configuration message");
        Message message = new Message();
        message.setMessage("Please make sure you have configured your scanner before creating your first Software Bill of Materials!");
        message.setType(MessageType.SCANNER_CONFIG);
        message.setSource(MessageSource.LOCAL);
        message.addAction("/configuration/scanners", "Configure scanner");
        this.messageRepository.create(message);
    }

    private boolean isConfiguredAndValid() {
        return this.scannerPreferencesRepository.getPreferences().map(prefs -> {
            String rootFolderId = prefs.getRootFolderId();
            String repositoryFolderId = prefs.getLocalRepositoryFolderId();
            if (!StringUtils.isNotBlank((CharSequence)rootFolderId) || !StringUtils.isNotBlank((CharSequence)repositoryFolderId)) {
                LOGGER.debug("One or both folder IDs are missing");
                return false;
            }
            boolean rootValid = this.isFolderIdValid(rootFolderId, "Root folder");
            boolean repoValid = this.isFolderIdValid(repositoryFolderId, "Repository folder");
            return rootValid && repoValid;
        }).orElse(false);
    }

    private boolean isFolderIdValid(String folderId, String folderName) {
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(folderId);
            String decodedPath = new String(decodedBytes, StandardCharsets.UTF_8);
            Path folderPath = Paths.get(decodedPath, new String[0]);
            if (!Files.exists(folderPath, new LinkOption[0])) {
                LOGGER.debug("{} does not exist: {}", (Object)folderName, (Object)decodedPath);
                return false;
            }
            if (!Files.isDirectory(folderPath, new LinkOption[0])) {
                LOGGER.debug("{} is not a directory: {}", (Object)folderName, (Object)decodedPath);
                return false;
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("{} ID is not valid base64: {}", (Object)folderName, (Object)folderId);
            return false;
        }
        catch (Exception e) {
            LOGGER.debug("Error validating {}: {}", (Object)folderName, (Object)e.getMessage());
            return false;
        }
    }

    private boolean messageExists() {
        return this.messageRepository.findAll().stream().anyMatch(msg -> MessageType.SCANNER_CONFIG.equals((Object)msg.getType()));
    }
}

