/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.core.db.migration;

import com.castsoftware.sca.scar.server.core.db.DatabaseTask;
import com.castsoftware.sca.scar.server.core.db.DatabaseTaskContext;
import com.castsoftware.sca.scar.server.preference.domain.TableDefinition;
import com.castsoftware.sca.scar.server.preference.domain.TablePreferences;
import com.castsoftware.sca.scar.server.preference.repository.TablePreferencesRepository;
import com.castsoftware.sca.util.java.Suppliers;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.EnumUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;

public class V5_FilesTablesAddVersionColumn
extends DatabaseTask {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(V5_FilesTablesAddVersionColumn.class);
    private final TablePreferencesRepository tablePreferencesRepository;

    public V5_FilesTablesAddVersionColumn(@NonNull TablePreferencesRepository tablePreferencesRepository) {
        this.tablePreferencesRepository = tablePreferencesRepository;
    }

    protected void doExecute(@NonNull DatabaseTaskContext context) {
        String VERSION = "VERSION";
        LOGGER.info("Update preferences to add version column to files tables if needed");
        TableDefinition bomFilesDefinition = Optional.ofNullable((TableDefinition)EnumUtils.getEnum(TableDefinition.class, (String)"BOM_FILES")).orElseThrow(Suppliers.illegalArgument((String)"Unknown table name"));
        TablePreferences bomFilesReferences = this.tablePreferencesRepository.findByTableName(bomFilesDefinition.name()).orElse(new TablePreferences());
        if (!bomFilesReferences.getColumns().contains("VERSION")) {
            bomFilesReferences.getColumns().add(2, "VERSION");
        }
        this.tablePreferencesRepository.setTablePreferences(bomFilesReferences);
        TableDefinition catalogFilesDefinition = Optional.ofNullable((TableDefinition)EnumUtils.getEnum(TableDefinition.class, (String)"CATALOG_FILES")).orElseThrow(Suppliers.illegalArgument((String)"Unknown table name"));
        TablePreferences catalogFilesReferences = this.tablePreferencesRepository.findByTableName(catalogFilesDefinition.name()).orElse(new TablePreferences());
        if (!catalogFilesReferences.getColumns().contains("VERSION")) {
            catalogFilesReferences.getColumns().add(2, "VERSION");
        }
        this.tablePreferencesRepository.setTablePreferences(catalogFilesReferences);
    }
}

