/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.core.db.migration;

import com.castsoftware.sca.scar.server.bom.structure.BOMClassDefinition;
import com.castsoftware.sca.scar.server.component.dao.ComponentDao;
import com.castsoftware.sca.scar.server.core.db.OrientDbTaskWithSession;
import com.castsoftware.sca.scar.server.orientdb.configuration.RemoteDatabase;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.preference.domain.TableDefinition;
import com.castsoftware.sca.scar.server.preference.domain.TablePreferences;
import com.castsoftware.sca.scar.server.preference.repository.TablePreferencesRepository;
import com.castsoftware.sca.util.java.Suppliers;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.EnumUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;

public class V4_BOMVersionsToVersion
extends OrientDbTaskWithSession {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(V4_BOMVersionsToVersion.class);
    private final ComponentDao componentDao;
    private final TablePreferencesRepository tablePreferencesRepository;

    public V4_BOMVersionsToVersion(@NonNull RemoteDatabase database, @NonNull ComponentDao componentDao, @NonNull TablePreferencesRepository tablePreferencesRepository) {
        super(database);
        this.componentDao = componentDao;
        this.tablePreferencesRepository = tablePreferencesRepository;
    }

    public void runWithSession(@NonNull ODatabaseSession session) {
        LOGGER.info("Migrating Component versions => version...");
        OClass vComponentClass = session.getClass(BOMClassDefinition.V.VComponent.name());
        if (!vComponentClass.existsProperty("version")) {
            vComponentClass.createProperty("version", OType.STRING);
            this.componentDao.findAll(session).stream().filter(Objects::nonNull).filter(component -> component.getVersions() != null && component.getVersions().iterator().hasNext()).forEach(component -> {
                component.setVersion((String)component.getVersions().iterator().next());
                this.componentDao.save((Vertex)component, session);
            });
            LOGGER.info("Migration Component versions => version is finished...");
        } else {
            LOGGER.info("No need to migrate versions. Version column exists.");
        }
        TableDefinition bomComponentsDefinition = Optional.ofNullable((TableDefinition)EnumUtils.getEnum(TableDefinition.class, (String)"BOM_COMPONENTS")).orElseThrow(Suppliers.illegalArgument((String)"Unknown table name"));
        TablePreferences bomComponentsReferences = this.tablePreferencesRepository.findByTableName(bomComponentsDefinition.name()).orElse(new TablePreferences());
        bomComponentsReferences.getColumns().replaceAll(s -> s.equals("VERSIONS") ? "VERSION" : s);
        this.tablePreferencesRepository.setTablePreferences(bomComponentsReferences);
        TableDefinition catalogComponentsDefinition = Optional.ofNullable((TableDefinition)EnumUtils.getEnum(TableDefinition.class, (String)"CATALOG_COMPONENTS")).orElseThrow(Suppliers.illegalArgument((String)"Unknown table name"));
        TablePreferences catalogComponentsReferences = this.tablePreferencesRepository.findByTableName(catalogComponentsDefinition.name()).orElse(new TablePreferences());
        catalogComponentsReferences.getColumns().replaceAll(s -> s.equals("VERSIONS") ? "VERSION" : s);
        this.tablePreferencesRepository.setTablePreferences(catalogComponentsReferences);
    }
}

