/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.core.db.migration;

import com.castsoftware.sca.scar.server.core.db.OrientDbTask;
import com.castsoftware.sca.scar.server.orientdb.configuration.RemoteDatabase;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.user.dao.UserDao;
import com.castsoftware.sca.scar.server.user.dao.UserRoleDao;
import com.castsoftware.sca.scar.server.user.domain.FullUserVertex;
import com.castsoftware.sca.scar.server.user.domain.UserPermission;
import com.castsoftware.sca.scar.server.user.domain.UserRoleVertex;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;

public class V1_UpdateRoles
extends OrientDbTask {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(V1_UpdateRoles.class);
    private final UserDao userDao;
    private final UserRoleDao userRoleDao;

    public V1_UpdateRoles(@NonNull RemoteDatabase database, @NonNull UserDao userDao, @NonNull UserRoleDao userRoleDao) {
        super(database);
        this.userDao = userDao;
        this.userRoleDao = userRoleDao;
    }

    protected void run() {
        LOGGER.info("Refreshing Owner account permissions...");
        Optional owner = this.userDao.findOwnerUser();
        if (owner.isPresent()) {
            UserRoleVertex role = ((FullUserVertex)owner.get()).getUserRole();
            role.setPermissions(this.getFullPermissions());
            this.userRoleDao.save((Vertex)role);
            LOGGER.info("Permissions have been refreshed");
        } else {
            LOGGER.info("No Owner account present");
        }
    }

    private Set<String> getFullPermissions() {
        return Arrays.stream(UserPermission.values()).map(UserPermission::getName).collect(Collectors.toSet());
    }
}

