/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.core.db.initialization;

import com.castsoftware.sca.scar.server.core.db.OrientDbTask;
import com.castsoftware.sca.scar.server.orientdb.configuration.RemoteDatabase;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.user.dao.UserRoleDao;
import com.castsoftware.sca.scar.server.user.domain.UserPermission;
import com.castsoftware.sca.scar.server.user.domain.UserRoleType;
import com.castsoftware.sca.scar.server.user.domain.UserRoleVertex;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;

public class V7_DefaultRoleInitializer
extends OrientDbTask {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(V7_DefaultRoleInitializer.class);
    private final UserRoleDao userRoleDao;

    public V7_DefaultRoleInitializer(@NonNull RemoteDatabase database, @NonNull UserRoleDao userRoleDao) {
        super(database);
        this.userRoleDao = userRoleDao;
    }

    protected void run() {
        LOGGER.info("Initializing User Roles...");
        Optional oDefaultRole = this.userRoleDao.findByType(UserRoleType.DEFAULT).stream().findFirst();
        if (oDefaultRole.isEmpty()) {
            UserRoleVertex defaultRole = new UserRoleVertex();
            defaultRole.setName("Default");
            defaultRole.setType(UserRoleType.DEFAULT.name());
            defaultRole.setPermissions(this.getReadPermissions());
            this.userRoleDao.save((Vertex)defaultRole);
            LOGGER.info("Created default user role");
        } else {
            LOGGER.info("Default user role already exists");
        }
    }

    private Set<String> getReadPermissions() {
        return Arrays.stream(UserPermission.values()).map(UserPermission::getName).filter(p -> p.endsWith(".read")).collect(Collectors.toSet());
    }
}

