/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.core.db.initialization;

import com.castsoftware.sca.scar.server.core.db.DatabaseTask;
import com.castsoftware.sca.scar.server.core.db.DatabaseTaskContext;
import com.castsoftware.sca.scar.server.preference.domain.ReviewStep;
import com.castsoftware.sca.scar.server.preference.repository.ReviewStepsRepository;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;

public class V6_ReviewStepsInitializer
extends DatabaseTask {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(V6_ReviewStepsInitializer.class);
    private final ReviewStepsRepository reviewStepsRepository;

    public V6_ReviewStepsInitializer(@NonNull ReviewStepsRepository reviewStepsRepository) {
        this.reviewStepsRepository = reviewStepsRepository;
    }

    protected void doExecute(@NonNull DatabaseTaskContext context) {
        LOGGER.info("Initializing BOM Review Steps...");
        int count = this.reviewStepsRepository.count();
        if (count < 1) {
            LOGGER.info("Found no existing Review Steps");
            this.reviewStepsRepository.setSteps(Stream.of(this.createStep(0, "created"), this.createStep(1, "to be reviewed"), this.createStep(2, "under review"), this.createStep(3, "reviewed"), this.createStep(4, "archived")).collect(Collectors.toList()));
            LOGGER.info("5 Review Steps have been recorded in the database");
        } else {
            LOGGER.info("{} Review Steps already exist in the database", (Object)count);
        }
    }

    private @NonNull ReviewStep createStep(int index, String name) {
        ReviewStep document = new ReviewStep();
        document.setIndex(Integer.valueOf(index));
        document.setName(name);
        return document;
    }
}

