/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.core.db.initialization;

import com.castsoftware.sca.scar.server.core.db.DatabaseTask;
import com.castsoftware.sca.scar.server.core.db.DatabaseTaskContext;
import com.castsoftware.sca.scar.server.preference.domain.TablePreferences;
import com.castsoftware.sca.scar.server.preference.repository.TablePreferencesRepository;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.exception.Exceptions;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.springframework.core.io.Resource;

/*
 * Exception performing whole class analysis ignored.
 */
public class V5_TablePreferencesInitializer
extends DatabaseTask {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(V5_TablePreferencesInitializer.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private final TablePreferencesRepository tablePreferencesRepository;
    private final Resource tablePreferenceResource;

    public V5_TablePreferencesInitializer(@NonNull TablePreferencesRepository tablePreferencesRepository, @NonNull Resource tablePreferenceResource) {
        this.tablePreferencesRepository = tablePreferencesRepository;
        this.tablePreferenceResource = (Resource)Guards.notNull((Object)tablePreferenceResource, (String)"Preferences json file is mandatory");
    }

    protected void doExecute(@NonNull DatabaseTaskContext context) {
        LOGGER.info("Initializing Table Preferences...");
        int count = this.tablePreferencesRepository.count();
        if (count < 1) {
            LOGGER.info("Found no existing Table Preferences");
            LOGGER.info(String.format("Reading Table Preference data from resource (%s)", this.tablePreferenceResource.getFilename()));
            try {
                Collection preferences = V5_TablePreferencesInitializer.readTablePreferences((InputStream)this.tablePreferenceResource.getInputStream());
                preferences.forEach(arg_0 -> ((TablePreferencesRepository)this.tablePreferencesRepository).setTablePreferences(arg_0));
                LOGGER.info("{} Table Preferences have been recorded in the database", (Object)preferences.size());
            }
            catch (Throwable t) {
                throw Exceptions.wrap((Throwable)t);
            }
        } else {
            LOGGER.info("{} Table Preferences already exist in the database", (Object)count);
        }
    }

    public static @NonNull Collection<TablePreferences> readTablePreferences(@NonNull InputStream prefStream) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(prefStream);){
            HashSet<TablePreferences> preferences = new HashSet<TablePreferences>();
            ((ArrayNode)mapper.readValue((InputStream)bis, ArrayNode.class)).forEach(pref -> {
                TablePreferences preference = new TablePreferences();
                preference.setTableName(pref.get("tableName").asText());
                preference.setRowsPerPage(Integer.valueOf(pref.get("rowsPerPage").asInt()));
                if (pref.has("columns")) {
                    pref.get("columns").forEach(c -> preference.addColumn(c.asText()));
                }
                preferences.add(preference);
            });
            HashSet<TablePreferences> hashSet = preferences;
            return hashSet;
        }
    }
}

