/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.core.db.initialization;

import com.castsoftware.sca.scar.server.bom.dao.BomDao;
import com.castsoftware.sca.scar.server.bom.dao.CentralDao;
import com.castsoftware.sca.scar.server.core.db.OrientDbTask;
import com.castsoftware.sca.scar.server.core.db.initialization.structure.LicensePolicy;
import com.castsoftware.sca.scar.server.license.dao.LicenseDao;
import com.castsoftware.sca.scar.server.license.dao.LicensePolicyDao;
import com.castsoftware.sca.scar.server.license.domain.ComplianceLevel;
import com.castsoftware.sca.scar.server.license.domain.LicensePolicyVertex;
import com.castsoftware.sca.scar.server.orientdb.configuration.RemoteDatabase;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.Suppliers;
import com.castsoftware.sca.util.java.exception.Exceptions;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.springframework.core.io.Resource;

/*
 * Exception performing whole class analysis ignored.
 */
public class V4_LicensePolicyInitializer
extends OrientDbTask {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(V4_LicensePolicyInitializer.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private final LicensePolicyDao licensePolicyDao;
    private final LicenseDao licenseDao;
    private final CentralDao centralDao;
    private final BomDao bomDao;
    private final Resource policyResource;

    public V4_LicensePolicyInitializer(@NonNull RemoteDatabase database, @NonNull LicensePolicyDao licensePolicyDao, @NonNull LicenseDao licenseDao, @NonNull CentralDao centralDao, @NonNull BomDao bomDao, @NonNull Resource policyResource) {
        super(database);
        this.licensePolicyDao = licensePolicyDao;
        this.licenseDao = licenseDao;
        this.centralDao = centralDao;
        this.bomDao = bomDao;
        this.policyResource = (Resource)Guards.notNull((Object)policyResource, (String)"Policies json file is mandatory");
    }

    protected void run() {
        LOGGER.info("Initializing License Policies...");
        List lpvs = this.licensePolicyDao.findAll();
        if (lpvs.isEmpty()) {
            LOGGER.info("Found no existing License Policies");
            LOGGER.info(String.format("Reading License Policy data from resource (%s)", this.policyResource.getFilename()));
            try {
                Collection policies = V4_LicensePolicyInitializer.readPolicies((InputStream)this.policyResource.getInputStream());
                policies.forEach(arg_0 -> this.recordPolicy(arg_0));
                LOGGER.info("{} License Policies have been recorded in the database", (Object)policies.size());
            }
            catch (Throwable t) {
                throw Exceptions.wrap((Throwable)t);
            }
        } else {
            LOGGER.info("{} License Policies are already recorded in the database", (Object)lpvs.size());
        }
    }

    public static @NonNull Collection<LicensePolicy> readPolicies(@NonNull InputStream policyStream) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(policyStream);){
            HashMap policies = new HashMap();
            ArrayList nodes = new ArrayList();
            ((ArrayNode)mapper.readValue((InputStream)bis, ArrayNode.class)).forEach(nodes::add);
            JsonNode policyHeaders = nodes.stream().filter(n -> !n.has("spdxId")).findAny().orElseThrow(Suppliers.illegalState((String)"json must have license policy headers entry"));
            String defaultPolicy = Optional.ofNullable(policyHeaders.get("default")).orElseThrow(Suppliers.illegalState((String)"No default policy defined")).asText();
            policyHeaders.fields().forEachRemaining(entry -> {
                if (((String)entry.getKey()).startsWith("LP")) {
                    LicensePolicy policy = new LicensePolicy();
                    policy.setKey((String)entry.getKey());
                    policy.setTitle(((JsonNode)entry.getValue()).asText());
                    policy.setDefault(((String)entry.getKey()).equals(defaultPolicy));
                    policies.put((String)entry.getKey(), policy);
                }
            });
            nodes.stream().filter(n -> n.has("spdxId")).forEach(n -> {
                String spdxId = n.get("spdxId").asText();
                n.fields().forEachRemaining(field -> Optional.ofNullable((LicensePolicy)policies.get(field.getKey())).ifPresent(p -> p.addCompliance(spdxId, ComplianceLevel.valueOf((String)((JsonNode)field.getValue()).asText()))));
            });
            Collection<LicensePolicy> collection = policies.values();
            return collection;
        }
    }

    private void recordPolicy(@NonNull LicensePolicy lp) {
        LicensePolicyVertex policy = new LicensePolicyVertex(lp.getKey());
        policy.setTitle(lp.getTitle());
        LicensePolicyVertex savedPolicy = (LicensePolicyVertex)this.licensePolicyDao.save((Vertex)policy);
        if (lp.isDefault()) {
            this.centralDao.setDefaultPolicy(savedPolicy);
            this.bomDao.addPolicy(this.centralDao.getCatalog(), savedPolicy);
        }
        lp.getCompliances().forEach((l, c) -> this.licenseDao.findBySpdxId(l).ifPresent(dbl -> this.licensePolicyDao.addLicense(savedPolicy, dbl, c.getLinkStatus(), null)));
    }
}

