/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.core.db.initialization;

import com.castsoftware.sca.scar.server.core.db.OrientDbTask;
import com.castsoftware.sca.scar.server.core.db.initialization.structure.License;
import com.castsoftware.sca.scar.server.license.dao.LicenseDao;
import com.castsoftware.sca.scar.server.license.domain.LicenseCategory;
import com.castsoftware.sca.scar.server.license.domain.LicenseProperty;
import com.castsoftware.sca.scar.server.license.domain.LicenseVertex;
import com.castsoftware.sca.scar.server.orientdb.configuration.RemoteDatabase;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.util.java.Suppliers;
import com.castsoftware.sca.util.java.exception.Exceptions;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.springframework.core.io.Resource;

/*
 * Exception performing whole class analysis ignored.
 */
public class V3_LicenseInitializer
extends OrientDbTask {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(V3_LicenseInitializer.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final List<String> defaultKeys = Arrays.asList("spdxId", "title", "category", "varexc");
    private final LicenseDao licenseDao;
    private final Resource licenseResource;
    private final Resource detailResource;

    public V3_LicenseInitializer(@NonNull RemoteDatabase database, @NonNull LicenseDao licenseDao, @NonNull Resource licenseResource, @NonNull Resource detailResource) {
        super(database);
        this.licenseDao = licenseDao;
        this.licenseResource = licenseResource;
        this.detailResource = detailResource;
    }

    protected void run() {
        LOGGER.info("Initializing Licenses...");
        List lvs = this.licenseDao.findAll();
        if (lvs.isEmpty()) {
            LOGGER.info("Found no existing Licenses");
            LOGGER.info(String.format("Reading License data from resources (%s & %s)", this.licenseResource.getFilename(), this.detailResource.getFilename()));
            try {
                Collection licenses = V3_LicenseInitializer.readLicenses((InputStream)this.licenseResource.getInputStream(), (InputStream)this.detailResource.getInputStream());
                licenses.forEach(arg_0 -> this.recordLicense(arg_0));
                LOGGER.info("{} Licenses have been recorded in the database", (Object)licenses.size());
            }
            catch (Throwable t) {
                throw Exceptions.wrap((Throwable)t);
            }
        } else {
            LOGGER.info("{} Licenses are already recorded in the database", (Object)lvs.size());
        }
    }

    public static @NonNull Collection<License> readLicenses(@NonNull InputStream licenseStream, @NonNull InputStream detailsStream) throws IOException {
        HashMap licenses = new HashMap();
        try (BufferedInputStream bis = new BufferedInputStream(licenseStream);){
            ((ArrayNode)mapper.readValue((InputStream)bis, ArrayNode.class)).forEach(jsonNode -> {
                License license = new License();
                license.setSpdxId(jsonNode.get("spdxId").asText());
                license.setTitle(jsonNode.get("title").asText());
                license.setCategory(LicenseCategory.stream().filter(c -> c.name().equals(jsonNode.get("category").asText())).findAny().orElseThrow(Suppliers.illegalState((String)("unknown license category: " + jsonNode.get("category").asText()))));
                if (jsonNode.has("varexc")) {
                    Arrays.asList(jsonNode.get("varexc").asText().split(";")).forEach(arg_0 -> ((License)license).addException(arg_0));
                }
                Map mapping = LicenseProperty.stream().collect(Collectors.toMap(Enum::name, Function.identity()));
                jsonNode.fieldNames().forEachRemaining(field -> {
                    if (!defaultKeys.contains(field)) {
                        license.addProperty(Optional.ofNullable((LicenseProperty)mapping.get(field)).orElseThrow(Suppliers.illegalState((String)("unknown license property: " + field))));
                    }
                });
                licenses.put(license.getSpdxId(), license);
            });
        }
        bis = new BufferedInputStream(detailsStream);
        try {
            ((ArrayNode)mapper.readValue((InputStream)bis, ArrayNode.class)).forEach(jsonNode -> {
                String currentId = jsonNode.get("spdxId").asText();
                if (licenses.containsKey(currentId)) {
                    ((License)licenses.get(currentId)).setUrl(jsonNode.get("url").asText());
                    ((License)licenses.get(currentId)).setText(jsonNode.get("text").asText());
                }
            });
        }
        finally {
            ((InputStream)bis).close();
        }
        return licenses.values();
    }

    private void recordLicense(@NonNull License l) {
        LicenseVertex vertex = new LicenseVertex(l.getSpdxId());
        vertex.setTitle(l.getTitle());
        vertex.setCategory(l.getCategory().name());
        vertex.setProperties(l.getProperties().stream().map(Enum::name).collect(Collectors.toSet()));
        vertex.setExceptions(l.getExceptions());
        vertex.setUrl(l.getUrl());
        vertex.setText(l.getText());
        this.licenseDao.save((Vertex)vertex);
    }
}

