/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.core.db.initialization;

import com.castsoftware.sca.scar.server.bom.dao.BomDao;
import com.castsoftware.sca.scar.server.bom.dao.CentralDao;
import com.castsoftware.sca.scar.server.bom.dao.FolderDao;
import com.castsoftware.sca.scar.server.bom.domain.BomVertex;
import com.castsoftware.sca.scar.server.bom.domain.CentralVertex;
import com.castsoftware.sca.scar.server.bom.domain.FolderVertex;
import com.castsoftware.sca.scar.server.core.db.OrientDbTask;
import com.castsoftware.sca.scar.server.orientdb.configuration.RemoteDatabase;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.util.List;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;

public class V2_CentralCatalogInitializer
extends OrientDbTask {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(V2_CentralCatalogInitializer.class);
    private final CentralDao centralDao;
    private final BomDao bomDao;
    private final FolderDao folderDao;

    public V2_CentralCatalogInitializer(@NonNull RemoteDatabase database, @NonNull CentralDao centralDao, @NonNull BomDao bomDao, @NonNull FolderDao folderDao) {
        super(database);
        this.centralDao = centralDao;
        this.bomDao = bomDao;
        this.folderDao = folderDao;
    }

    protected void run() {
        List central = this.centralDao.findAll();
        if (central.isEmpty()) {
            CentralVertex centralVertex = new CentralVertex();
            this.centralDao.save((Vertex)centralVertex);
            BomVertex catalogVertex = new BomVertex();
            catalogVertex.setCatalog(true);
            this.bomDao.save((Vertex)catalogVertex);
            FolderVertex catalogRoot = (FolderVertex)this.folderDao.save((Vertex)new FolderVertex("/"));
            this.bomDao.addRoot(catalogVertex, catalogRoot);
            this.centralDao.setCatalog(catalogVertex);
            LOGGER.info("Initialized Catalog");
        } else {
            LOGGER.info("Catalog already exists");
        }
    }
}

