/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.core.db.initialization;

import com.castsoftware.sca.scar.server.autoconfiguration.component.application.Launcher;
import com.castsoftware.sca.scar.server.bom.structure.BOMClassDefinition;
import com.castsoftware.sca.scar.server.core.db.OrientDbTaskWithSession;
import com.castsoftware.sca.scar.server.kpi.structure.KPIClassDefinition;
import com.castsoftware.sca.scar.server.orientdb.configuration.RemoteDatabase;
import com.castsoftware.sca.scar.server.orientdb.structure.ClassDefinition;
import com.castsoftware.sca.scar.server.user.structure.UserClassDefinition;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import java.util.Arrays;
import java.util.stream.Stream;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;

public class V1_BomDbInitializer
extends OrientDbTaskWithSession {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(V1_BomDbInitializer.class);

    public V1_BomDbInitializer(@NonNull RemoteDatabase database) {
        super(database);
    }

    public void runWithSession(@NonNull ODatabaseSession session) {
        if (session.getClass("ERoot") == null) {
            this.createSchema(session);
            this.createIndexes(session);
            throw new Launcher.RestartException();
        }
        LOGGER.info("The database schema has already been initialized");
    }

    void createSchema(@NonNull ODatabaseSession session) {
        Stream.of(BOMClassDefinition.V.values(), BOMClassDefinition.E.values(), KPIClassDefinition.V.values(), KPIClassDefinition.E.values(), UserClassDefinition.V.values(), UserClassDefinition.E.values()).flatMap(Arrays::stream).forEachOrdered(def -> ((ClassDefinition)def).describe(session));
        Stream.of(BOMClassDefinition.I.values()).forEachOrdered(def -> def.describe(session));
        LOGGER.info("Initialized database schema");
    }

    void createIndexes(@NonNull ODatabaseSession session) {
        if (this.hasNoIndexes("VLicense.spdxId", session)) {
            session.command("CREATE PROPERTY VLicense.spdxId IF NOT EXISTS STRING (COLLATE \"ci\", MANDATORY TRUE, NOTNULL TRUE)", new Object[0]);
            session.command("CREATE INDEX VLicense.spdxId ON VLicense (spdxId) UNIQUE", new Object[0]);
            session.command("CREATE PROPERTY VLicense.title IF NOT EXISTS STRING (COLLATE \"ci\")", new Object[0]);
            session.command("CREATE INDEX VLicense.title ON VLicense (title) NOTUNIQUE", new Object[0]);
            LOGGER.info("Created License indexes");
        } else {
            LOGGER.info("License indexes already exist");
        }
        if (this.hasNoIndexes("VSnippet.name", session)) {
            session.command("CREATE PROPERTY VSnippet.name IF NOT EXISTS STRING (MANDATORY TRUE, NOTNULL TRUE)", new Object[0]);
            session.command("CREATE INDEX VSnippet.name ON VSnippet (name) NOTUNIQUE", new Object[0]);
            LOGGER.info("Created Snippet indexes");
        } else {
            LOGGER.info("Snippet indexes already exist");
        }
        if (this.hasNoIndexes("VUser.email", session)) {
            session.command("CREATE PROPERTY VUser.email IF NOT EXISTS STRING (MANDATORY TRUE, NOTNULL TRUE)", new Object[0]);
            session.command("CREATE INDEX VUser.email ON VUser (email) UNIQUE", new Object[0]);
            LOGGER.info("Created User indexes");
        } else {
            LOGGER.info("User indexes already exist");
        }
    }

    private boolean hasNoIndexes(String name, @NonNull ODatabaseSession session) {
        return session.query("SELECT EXPAND(indexes) FROM metadata:indexmanager", new Object[0]).stream().map(i -> i.getProperty("name").toString()).noneMatch(i -> i.equals(name));
    }
}

