/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.core.db;

import com.castsoftware.sca.scar.server.core.db.DatabaseTask;
import com.castsoftware.sca.scar.server.core.db.DatabaseTaskContext;
import com.castsoftware.sca.scar.server.orientdb.configuration.RemoteDatabase;
import com.castsoftware.sca.scar.server.orientdb.dao.BaseDao;
import com.castsoftware.sca.util.java.exception.IllegalConfigurationException;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class OrientDbTaskWithSession
extends DatabaseTask {
    protected final RemoteDatabase database;

    protected OrientDbTaskWithSession(@NonNull RemoteDatabase database) {
        this.database = database;
    }

    private String database() {
        return this.database.getName();
    }

    protected final void doExecute(@NonNull DatabaseTaskContext context) {
        this.validateDatabase(context);
        try (ODatabasePool pool = context.getPoolBuilder().build(context.getRootConfig(), context.getEmbeddedServer());){
            new BaseDao(pool).execute(arg_0 -> this.runWithSession(arg_0));
        }
    }

    private void validateDatabase(@NonNull DatabaseTaskContext context) {
        String configuredDb = context.getPoolBuilder().getDatabase().getName();
        if (!configuredDb.equals(this.database())) {
            throw new IllegalConfigurationException(String.format("Database name mismatch for task %s: expected '%s', configured '%s'", this.getTaskName(), this.database(), configuredDb));
        }
    }

    public abstract void runWithSession(@NonNull ODatabaseSession var1);
}

