/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.core.db;

import com.castsoftware.sca.scar.server.core.db.DatabaseTask;
import com.castsoftware.sca.scar.server.core.db.DatabaseTaskContext;
import com.castsoftware.sca.scar.server.orientdb.configuration.RemoteDatabase;
import com.castsoftware.sca.util.java.exception.IllegalConfigurationException;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class OrientDbTask
extends DatabaseTask {
    protected final RemoteDatabase database;

    protected OrientDbTask(@NonNull RemoteDatabase database) {
        this.database = database;
    }

    private String database() {
        return this.database.getName();
    }

    protected final void doExecute(@NonNull DatabaseTaskContext context) {
        this.validateDatabase(context);
        this.run();
    }

    private void validateDatabase(@NonNull DatabaseTaskContext context) {
        String configuredDb = context.getPoolBuilder().getDatabase().getName();
        if (!configuredDb.equals(this.database())) {
            throw new IllegalConfigurationException(String.format("Database name mismatch for task %s: expected '%s', configured '%s'", this.getTaskName(), this.database(), configuredDb));
        }
    }

    protected abstract void run();
}

