/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.core.dao;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class JsonFileRepository<T> {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private Map<String, T> storage;
    private final Path filePath;
    private final ObjectMapper objectMapper;
    private final JavaType mapType;

    public JsonFileRepository(Path storageDirectory, String fileName, ObjectMapper objectMapper, JavaType valueType) {
        this.filePath = storageDirectory.resolve(Path.of(fileName, new String[0]));
        this.objectMapper = objectMapper;
        this.mapType = this.buildMapType(valueType);
        this.loadStorage();
    }

    private JavaType buildMapType(JavaType valueType) {
        TypeFactory factory = this.objectMapper.getTypeFactory();
        return factory.constructMapType(Map.class, factory.constructType(String.class), valueType);
    }

    private Map<String, T> getStorage() {
        this.readLock.lock();
        try {
            Map map = this.storage;
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected int count() {
        return this.getStorage().size();
    }

    protected Collection<T> findAll() {
        return this.getStorage().values();
    }

    protected Optional<T> findByKey(String key) {
        return Optional.ofNullable(this.getStorage().get(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(String key, T value) {
        this.writeLock.lock();
        try {
            this.storage.put(key, value);
            Files.createDirectories(this.filePath.getParent(), new FileAttribute[0]);
            this.objectMapper.writeValue(this.filePath.toFile(), (Object)this.storage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean deleteByKey(String key) {
        this.writeLock.lock();
        try {
            boolean existed = this.storage.containsKey(key);
            if (existed) {
                this.storage.remove(key);
                Files.createDirectories(this.filePath.getParent(), new FileAttribute[0]);
                this.objectMapper.writeValue(this.filePath.toFile(), (Object)this.storage);
            }
            boolean bl = existed;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void clear() {
        this.writeLock.lock();
        try {
            this.storage.clear();
            Files.createDirectories(this.filePath.getParent(), new FileAttribute[0]);
            this.objectMapper.writeValue(this.filePath.toFile(), (Object)this.storage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void loadStorage() {
        this.writeLock.lock();
        try {
            if (Files.exists(this.filePath, new LinkOption[0])) {
                byte[] jsonData = Files.readAllBytes(this.filePath);
                this.storage = (Map)this.objectMapper.readValue(jsonData, this.mapType);
            } else {
                this.storage = new HashMap();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.storage = new HashMap();
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

