/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.component.service;

import com.castsoftware.sca.scar.server.component.dao.ComponentDao;
import com.castsoftware.sca.scar.server.component.domain.ComponentVertex;
import com.castsoftware.sca.scar.server.component.exception.ComponentExceptions;
import com.castsoftware.sca.scar.server.component.handler.ComponentTransforms;
import com.castsoftware.sca.scar.server.component.model.ComponentView;
import com.castsoftware.sca.scar.server.component.model.DependencyView;
import com.castsoftware.sca.scar.server.sam.domain.data.ScaDependencyResult;
import com.castsoftware.sca.scar.server.sam.requester.DataApiRequester;
import com.castsoftware.sca.scar.server.util.RequestUtils;
import com.castsoftware.sca.util.java.Opt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;

public class ComponentReadService {
    private final ComponentDao componentDao;
    private final DataApiRequester dataAPI;

    public ComponentReadService(ComponentDao componentDao, DataApiRequester dataAPI) {
        this.componentDao = componentDao;
        this.dataAPI = dataAPI;
    }

    public ComponentView get(String componentId) {
        return this.componentDao.findByIdWithLV(RequestUtils.decodeId((String)componentId)).map(ComponentTransforms::from).orElseThrow(() -> ComponentExceptions.componentNotFound((String)componentId));
    }

    public Map<String, Long> getAllVersions(String id) {
        return this.componentDao.findById(RequestUtils.decodeId((String)id)).map(ComponentVertex::getAllVersions).orElseThrow(NoSuchElementException::new);
    }

    public Collection<DependencyView> getDependencies(String componentId) {
        return this.componentDao.findById(RequestUtils.decodeId((String)componentId)).filter(componentVertex -> Opt.ofBlankString((String)componentVertex.getLastVersion()).isPresent()).map(componentVertex -> this.getDependencies(componentVertex, Optional.ofNullable(componentVertex.getVersion()).filter(v -> !v.isEmpty()).orElseGet(() -> ((ComponentVertex)componentVertex).getLastVersion()))).orElseGet(ArrayList::new);
    }

    public Collection<DependencyView> getDependencies(String componentId, String componentVersion) {
        return this.componentDao.findById(RequestUtils.decodeId((String)componentId)).map(componentVertex -> this.getDependencies(componentVertex, componentVersion)).orElseGet(ArrayList::new);
    }

    private Collection<DependencyView> getDependencies(ComponentVertex vertex, String componentVersion) {
        ScaDependencyResult subRes;
        if (Optional.ofNullable(vertex).map(ComponentVertex::getScaId).flatMap(Opt::ofBlankString).isPresent() && (subRes = this.dataAPI.getDependencies(vertex.getScaId(), componentVersion)) != null) {
            List<DependencyView> result = subRes.getDependencies().stream().map(ComponentTransforms::to).collect(Collectors.toList());
            while (subRes.getHref() != null) {
                subRes = this.dataAPI.getDependenciesNext(subRes.getHref().getNext());
                result.addAll(subRes.getDependencies().stream().map(ComponentTransforms::to).toList());
            }
            return result;
        }
        return new ArrayList<DependencyView>();
    }
}

