/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.component.service;

import com.castsoftware.sca.scar.server.analyzer.structure.BomSource;
import com.castsoftware.sca.scar.server.analyzer.structure.DefaultCategory;
import com.castsoftware.sca.scar.server.bom.dao.BomDao;
import com.castsoftware.sca.scar.server.bom.dao.FileDao;
import com.castsoftware.sca.scar.server.bom.dao.SnippetDao;
import com.castsoftware.sca.scar.server.bom.domain.BomComponentVertex;
import com.castsoftware.sca.scar.server.bom.domain.BomVertex;
import com.castsoftware.sca.scar.server.bom.domain.FileVertex;
import com.castsoftware.sca.scar.server.bom.domain.SnippetVertex;
import com.castsoftware.sca.scar.server.bom.structure.BOMClassDefinition;
import com.castsoftware.sca.scar.server.component.dao.ComponentDao;
import com.castsoftware.sca.scar.server.component.domain.ComponentRescanTask;
import com.castsoftware.sca.scar.server.component.domain.ComponentVertex;
import com.castsoftware.sca.scar.server.component.handler.ComponentSortHandler;
import com.castsoftware.sca.scar.server.component.handler.OperationHandler;
import com.castsoftware.sca.scar.server.component.model.request.CreateComponentRequest;
import com.castsoftware.sca.scar.server.component.model.request.FullUpdateRequest;
import com.castsoftware.sca.scar.server.component.model.request.RepositoryType;
import com.castsoftware.sca.scar.server.component.service.ComponentEditService;
import com.castsoftware.sca.scar.server.kpi.handler.KPIComputer;
import com.castsoftware.sca.scar.server.license.dao.LicenseDao;
import com.castsoftware.sca.scar.server.license.domain.LicenseVertex;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.orientdb.structure.EClassDefinition;
import com.castsoftware.sca.scar.server.preference.domain.BomPreferences;
import com.castsoftware.sca.scar.server.preference.domain.BomType;
import com.castsoftware.sca.scar.server.preference.repository.BomPreferencesRepository;
import com.castsoftware.sca.scar.server.risk.ObsolescenceComputer;
import com.castsoftware.sca.scar.server.sam.requester.DataApiRequester;
import com.castsoftware.sca.scar.server.util.RequestUtils;
import com.castsoftware.sca.scar.server.util.event.EventListener;
import com.castsoftware.sca.scar.server.util.task.TaskExecutor;
import com.castsoftware.sca.scar.server.util.task.TaskRunnable;
import com.castsoftware.sca.scar.server.vulnerability.dao.VulnerabilityDao;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityVertex;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.Opt;
import com.castsoftware.sca.util.java.Suppliers;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;

public class ComponentEditService {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(ComponentEditService.class);
    private final ComponentDao componentDao;
    private final BomDao bomDao;
    private final LicenseDao licenseDao;
    private final VulnerabilityDao vulnerabilityDao;
    private final FileDao fileDao;
    private final SnippetDao snippetDao;
    private final KPIComputer kpiComputer;
    private final BomPreferencesRepository bomPreferencesRepository;
    private final DataApiRequester dataAPI;
    private final TaskExecutor<ComponentRescanTask> componentRescanExecutor;
    private static final ReentrantLock splitLock = new ReentrantLock();
    private static final ReentrantLock lock = new ReentrantLock();

    public ComponentEditService(ComponentDao componentDao, BomDao bomDao, LicenseDao licenseDao, VulnerabilityDao vulnerabilityDao, FileDao fileDao, SnippetDao snippetDao, KPIComputer kpiComputer, BomPreferencesRepository bomPreferencesRepository, DataApiRequester requester, TaskExecutor<ComponentRescanTask> componentRescanExecutor) {
        this.componentDao = componentDao;
        this.bomDao = bomDao;
        this.licenseDao = licenseDao;
        this.vulnerabilityDao = vulnerabilityDao;
        this.fileDao = fileDao;
        this.snippetDao = snippetDao;
        this.kpiComputer = kpiComputer;
        this.bomPreferencesRepository = bomPreferencesRepository;
        this.dataAPI = requester;
        this.componentRescanExecutor = componentRescanExecutor;
    }

    public void rename(String componentId, String newName) {
        Guards.notBlank((String)newName);
        ComponentVertex component = (ComponentVertex)this.componentDao.findById(RequestUtils.decodeId((String)componentId)).orElseThrow(NoSuchElementException::new);
        BomVertex bomVertex = (BomVertex)this.bomDao.findByComponent(component.getId()).orElseThrow(NoSuchElementException::new);
        component.recordEdit();
        component.setName(newName);
        this.componentDao.withTransaction(session -> {
            if (component.isContentEdited()) {
                this.updateAndSaveComponent(component, session, true);
                this.updateBomStatus(bomVertex, session);
            }
        });
    }

    public void createNewComponent(String bomId, CreateComponentRequest request) {
        Guards.notBlank((String)request.getName(), (Supplier)Suppliers.illegalArgument((String)"Component name is mandatory"));
        BomVertex bomVertex = (BomVertex)this.bomDao.findById(RequestUtils.decodeId((String)bomId)).orElseThrow(() -> new NoSuchElementException("BOM not found"));
        ComponentVertex newComponent = new ComponentVertex(request.getName());
        newComponent.setVersion(Objects.requireNonNullElse(request.getVersion(), ""));
        newComponent.setDescription(Objects.requireNonNullElse(request.getDescription(), ""));
        newComponent.setRepository(request.getRepository() != null ? request.getRepository().getValue() : "");
        newComponent.setSource(BomSource.LOCAL.name());
        newComponent.setScaId(request.getName() + this.getScaIdExtensionForRepository(request.getRepository()));
        String categoryName = Opt.ofBlankString((String)request.getCategory()).orElse(DefaultCategory.SANDBOX.name());
        List licenseVertices = Optional.ofNullable(request.getLicenses()).orElse(Collections.emptyList()).stream().map(arg_0 -> ((LicenseDao)this.licenseDao).findBySpdxId(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        this.componentDao.withTransaction(session -> {
            ComponentVertex savedComponent = (ComponentVertex)this.componentDao.save((Vertex)newComponent, session);
            BomComponentVertex bomComponent = new BomComponentVertex(savedComponent, (Collection)licenseVertices, Collections.emptyList());
            bomComponent.setCategory(categoryName);
            this.bomDao.addComponent(bomVertex, (ComponentVertex)bomComponent, categoryName, session);
            SnippetVertex snippet = new SnippetVertex(newComponent.getName());
            snippet.setScaId(newComponent.getScaId());
            snippet.setVersion(newComponent.getVersion());
            this.snippetDao.save((Vertex)snippet, session);
            this.componentDao.addSnippet(savedComponent, snippet, session);
            if (!licenseVertices.isEmpty()) {
                this.updateLicenses(bomComponent, session);
            }
            this.updateBomStatus(bomVertex, session);
        });
        this.kpiComputer.computeBasicKPIBackground(bomVertex, new EventListener[0]);
    }

    public void deleteComponent(String componentId) {
        String decodedId = RequestUtils.decodeId((String)componentId);
        ComponentVertex component = (ComponentVertex)this.componentDao.findById(decodedId).orElseThrow(() -> new NoSuchElementException("Component not found"));
        if (component.countFiles() != null && component.countFiles() > 0L) {
            throw new IllegalArgumentException("Cannot delete component with files attached");
        }
        BomVertex bomVertex = (BomVertex)this.bomDao.findByComponent(decodedId).orElseThrow(() -> new NoSuchElementException("BOM not found for component"));
        if (bomVertex.isCatalog()) {
            List linkedComponents = this.componentDao.findByLink(component.getId(), BOMClassDefinition.V.VComponent, BOMClassDefinition.E.EFrom);
            linkedComponents.forEach(c -> {
                c.setSource(BomSource.LOCAL.name());
                this.componentDao.save((Vertex)c);
                this.componentDao.unlink((Vertex)c, (Vertex)component, (EClassDefinition)BOMClassDefinition.E.EFrom);
            });
        }
        this.componentDao.withTransaction(session -> {
            this.componentDao.delete((Vertex)component, session);
            this.updateBomStatus(bomVertex, session);
        });
        this.kpiComputer.computeBasicKPIBackground(bomVertex, new EventListener[0]);
    }

    private String getScaIdExtensionForRepository(RepositoryType repository) {
        if (repository == null) {
            return "";
        }
        return switch (2.$SwitchMap$com$castsoftware$sca$scar$server$component$model$request$RepositoryType[repository.ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> "";
            case 2 -> "";
            case 3 -> ".npm";
            case 4 -> ".rs";
            case 5 -> ".php";
            case 6 -> ".rb";
            case 7 -> ".py";
            case 8 -> ".NET";
            case 9 -> "";
        };
    }

    public void updateComponent(String id, FullUpdateRequest request) {
        this.updateComponent(RequestUtils.decodeId((String)id), request, false);
    }

    public void merge(List<String> ids, String mergeName, String mergeDescription, String selectedId) {
        Guards.notBlank((String)mergeName, (Supplier)Suppliers.illegalArgument((String)"name is mandatory"));
        List fromComponents = Guards.minimumSize(ids, (long)2L).stream().map(id -> this.componentDao.findByIdWithLV(RequestUtils.decodeId((String)id))).flatMap(o -> o.map(Stream::of).orElseThrow(NoSuchElementException::new)).collect(Collectors.toList());
        BomVertex bomVertex = (BomVertex)this.bomDao.findByComponent(((ComponentVertex)fromComponents.getFirst()).getId()).orElseThrow(NoSuchElementException::new);
        List files = fromComponents.stream().flatMap(c -> this.fileDao.findByComponent(c.getId()).stream()).collect(Collectors.toList());
        List snippets = fromComponents.stream().flatMap(c -> this.snippetDao.findByComponent(c.getId()).stream()).collect(Collectors.toList());
        BomComponentVertex mergedComponent = Opt.ofBlankString((String)selectedId).map(id -> this.createWithSelected(mergeName, fromComponents, id)).orElseGet(() -> this.createAndMergeFields(mergeName, fromComponents));
        mergedComponent.setSource(BomSource.LOCAL.name());
        mergedComponent.setDescription(mergeDescription);
        mergedComponent.setPath(OperationHandler.recomputePath(files));
        String categoryName = this.bomPreferencesRepository.findByType(bomVertex.isCatalog() ? BomType.CATALOG.name() : BomType.BOMS.name()).map(BomPreferences::isMoveMergedComponents).filter(move -> move).map(move -> DefaultCategory.SANDBOX.name()).orElse(((ComponentVertex)fromComponents.getFirst()).getCategory());
        mergedComponent.setCategory(categoryName);
        mergedComponent.setComments(OperationHandler.createMergeComment(fromComponents));
        this.componentDao.withTransaction(session -> {
            this.componentDao.save((Vertex)mergedComponent, session);
            this.bomDao.addComponent(bomVertex, (ComponentVertex)mergedComponent, categoryName, session);
            this.updateLicenses(mergedComponent, session);
            this.updateVulnerabilities(mergedComponent, session);
            if (!files.isEmpty()) {
                mergedComponent.setCountFiles(Long.valueOf(0L));
                this.addFiles((ComponentVertex)mergedComponent, files, session);
            }
            if (!snippets.isEmpty()) {
                this.addSnippets((ComponentVertex)mergedComponent, snippets, session);
            }
            fromComponents.forEach(c -> this.componentDao.delete((Vertex)c, session));
            this.updateBomStatus(bomVertex, session);
        });
        this.kpiComputer.computeBasicKPIBackground(bomVertex, new EventListener[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void split(String id, Function<FileVertex, String> mapper) {
        Guards.notNull(mapper, IllegalStateException::new);
        splitLock.lock();
        try {
            BomComponentVertex componentToSplit = (BomComponentVertex)this.componentDao.findByIdWithLV(RequestUtils.decodeId((String)id)).orElseThrow(NoSuchElementException::new);
            Collection snippets = this.snippetDao.findByComponent(componentToSplit.getId());
            BomVertex bomVertex = (BomVertex)this.bomDao.findByComponent(componentToSplit.getId()).orElseThrow(NoSuchElementException::new);
            String categoryName = this.bomPreferencesRepository.findByType(bomVertex.isCatalog() ? BomType.CATALOG.name() : BomType.BOMS.name()).map(BomPreferences::isMoveSplitComponents).filter(Boolean.TRUE::equals).map(move -> DefaultCategory.SANDBOX.name()).orElse(componentToSplit.getCategory());
            Map<BomComponentVertex, List> splitGroup = this.fileDao.findByComponentWithLicense(componentToSplit.getId()).stream().collect(Collectors.groupingBy(mapper)).entrySet().stream().map(e -> {
                ComponentVertex c = componentToSplit.copy();
                c.setName(c.getName() + " (" + (String)e.getKey() + ")");
                c.setSource(BomSource.LOCAL.name());
                c.setPath(OperationHandler.recomputePath((Collection)((Collection)e.getValue())));
                c.setCategory(categoryName);
                c.setComments(OperationHandler.createSplitComment((ComponentVertex)componentToSplit));
                c.setModified(false);
                List licenses = ((List)e.getValue()).stream().map(FileVertex::getLicenses).flatMap(Collection::stream).filter(OperationHandler.distinct(LicenseVertex::getSpdxId)).collect(Collectors.toList());
                return new AbstractMap.SimpleEntry<BomComponentVertex, List>(new BomComponentVertex(c, licenses, componentToSplit.getVulnerabilities()), (List)e.getValue());
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (!splitGroup.isEmpty()) {
                this.componentDao.withTransaction(session -> {
                    splitGroup.forEach((component, fileList) -> {
                        this.componentDao.save((Vertex)component, session);
                        this.bomDao.addComponent(bomVertex, (ComponentVertex)component, categoryName, session);
                        this.updateLicenses(component, session);
                        this.updateVulnerabilities(component, session);
                        this.updateFiles((ComponentVertex)component, fileList, session);
                    });
                    if (!snippets.isEmpty()) {
                        ComponentVertex first = (ComponentVertex)splitGroup.keySet().stream().findFirst().orElseThrow(IllegalStateException::new);
                        snippets.forEach(s -> this.componentDao.addSnippet(first, s, session));
                    }
                    this.componentDao.delete((Vertex)componentToSplit, session);
                    this.updateBomStatus(bomVertex, session);
                });
                try {
                    this.kpiComputer.computeBasicKPIBackground(bomVertex, new EventListener[0]);
                }
                catch (Exception e2) {
                    LOGGER.warn("ignored computeBasicKPIBackground");
                }
            }
        }
        finally {
            splitLock.unlock();
        }
    }

    public void moveFiles(List<String> fileIds, String destId) {
        Guards.minimumSize(fileIds, (long)1L, (Supplier)Suppliers.illegalArgument((String)"at least one file must be specified"));
        ComponentVertex originalComponent = (ComponentVertex)this.componentDao.findByFile(RequestUtils.decodeId((String)fileIds.getFirst())).orElseThrow(NoSuchElementException::new);
        BomComponentVertex destComponent = (BomComponentVertex)this.componentDao.findByIdWithLV(RequestUtils.decodeId((String)destId)).orElseThrow(NoSuchElementException::new);
        BomVertex bomVertex = (BomVertex)this.bomDao.findByComponent(originalComponent.getId()).orElseThrow(NoSuchElementException::new);
        this.componentDao.withTransaction(session -> {
            this.updateAndSaveComponent((ComponentVertex)destComponent, session, true);
            this.internalMoveFiles(fileIds, originalComponent, destComponent, session, false);
            this.updateLicenses(destComponent, session);
            this.updateBomStatus(bomVertex, session);
        });
        this.recomputeFileCountForComponent((ComponentVertex)destComponent);
        this.kpiComputer.computeBasicKPIBackground(bomVertex, new EventListener[0]);
    }

    public void createFromFiles(List<String> fileIds, String name, String description) {
        Guards.minimumSize(fileIds, (long)1L, (Supplier)Suppliers.illegalArgument((String)"at least one file must be specified"));
        Guards.notBlank((String)name, (Supplier)Suppliers.illegalArgument((String)"name is mandatory"));
        ComponentVertex originalComponent = (ComponentVertex)this.componentDao.findByFile(RequestUtils.decodeId((String)fileIds.getFirst())).orElseThrow(NoSuchElementException::new);
        BomVertex bomVertex = (BomVertex)this.bomDao.findByComponent(originalComponent.getId()).orElseThrow(NoSuchElementException::new);
        ComponentVertex newComponent = new ComponentVertex(name);
        newComponent.setDescription(description);
        newComponent.setSource(BomSource.LOCAL.name());
        newComponent.setCategory(DefaultCategory.SANDBOX.name());
        this.componentDao.withTransaction(session -> {
            ComponentVertex savedComponent = (ComponentVertex)this.componentDao.save((Vertex)newComponent, session);
            BomComponentVertex destComponent = new BomComponentVertex(savedComponent, null, null);
            this.internalMoveFiles(fileIds, originalComponent, destComponent, session, true);
            this.bomDao.addComponent(bomVertex, (ComponentVertex)destComponent, DefaultCategory.SANDBOX.name(), session);
            this.updateLicenses(destComponent, session);
            this.updateBomStatus(bomVertex, session);
        });
        this.kpiComputer.computeBasicKPIBackground(bomVertex, new EventListener[0]);
    }

    public String rescanComponent(@NonNull String componentId) {
        if (componentId == null) {
            throw new NullPointerException("componentId is marked non-null but is null");
        }
        return this.componentRescanExecutor.execute((TaskRunnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private BomComponentVertex createAndMergeFields(String mergeName, List<ComponentVertex> fromComponents) {
        List licenses = OperationHandler.mergeLicenses(fromComponents);
        List vulnerabilities = OperationHandler.mergeVulnerabilities(fromComponents);
        BomComponentVertex mergedComponent = new BomComponentVertex(new ComponentVertex(mergeName), (Collection)licenses, (Collection)vulnerabilities);
        mergedComponent.setScaId((String)OperationHandler.getUniqueOrDefault(fromComponents, ComponentVertex::getScaId, (Object)""));
        mergedComponent.setVersion((String)OperationHandler.getUniqueOrDefault(fromComponents, ComponentVertex::getVersion, (Object)""));
        mergedComponent.setLastVersion((String)OperationHandler.getUniqueOrDefault(fromComponents, ComponentVertex::getLastVersion, (Object)""));
        mergedComponent.setAllVersions((Map)OperationHandler.getUniqueOrDefault(fromComponents, ComponentVertex::getAllVersions, new LinkedHashMap()));
        mergedComponent.setRepoType((String)OperationHandler.getUniqueOrDefault(fromComponents, ComponentVertex::getRepoType, (Object)""));
        mergedComponent.setRepository((String)OperationHandler.getUniqueOrDefault(fromComponents, ComponentVertex::getRepository, (Object)""));
        mergedComponent.setLanguages(OperationHandler.mergeLists(fromComponents, ComponentVertex::getLanguages));
        mergedComponent.setTopics(OperationHandler.mergeLists(fromComponents, ComponentVertex::getTopics));
        mergedComponent.setReferences(OperationHandler.mergeLists(fromComponents, ComponentVertex::getReferences));
        mergedComponent.setCopyright(OperationHandler.mergeCopyright(fromComponents));
        mergedComponent.setUpToDate(ObsolescenceComputer.compute((String)mergedComponent.getVersion(), (String)mergedComponent.getLastVersion(), (Map)mergedComponent.getAllVersions()).name());
        return mergedComponent;
    }

    private BomComponentVertex createWithSelected(String mergeName, List<ComponentVertex> fromComponents, String selectedId) {
        ComponentVertex selectedComponent = fromComponents.stream().filter(c -> c.getId().equals(RequestUtils.decodeId((String)selectedId))).findAny().orElseThrow(IllegalArgumentException::new);
        BomComponentVertex mergedComponent = new BomComponentVertex(selectedComponent.copy(), ((BomComponentVertex)selectedComponent).getLicenses(), ((BomComponentVertex)selectedComponent).getVulnerabilities());
        mergedComponent.setName(mergeName);
        return mergedComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateComponent(String id, FullUpdateRequest request, boolean isLinkedComponent) {
        boolean hasChangedVulnerabilities;
        boolean hasChangedLicenses;
        BomComponentVertex componentVertex = (BomComponentVertex)this.componentDao.findByIdWithLV(id).orElseThrow(NoSuchElementException::new);
        BomVertex bomVertex = (BomVertex)this.bomDao.findByComponent(componentVertex.getId()).orElseThrow(NoSuchElementException::new);
        AtomicInteger licenseIndex = new AtomicInteger();
        AtomicInteger vulnerabilityIndex = new AtomicInteger();
        List reqLicenses = Objects.requireNonNullElse(request.getLicenses(), new ArrayList());
        boolean bl = hasChangedLicenses = !componentVertex.getLicenses().stream().map(LicenseVertex::getSpdxId).toList().equals(reqLicenses);
        if (hasChangedLicenses) {
            List licenseVertices = reqLicenses.stream().map(arg_0 -> ((LicenseDao)this.licenseDao).findBySpdxId(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            componentVertex.setLicenses(licenseVertices);
            licenseIndex.set(ComponentSortHandler.computeLicenseSortIndex(licenseVertices, (Collection)this.licenseDao.findBomLicenses(bomVertex.getId())));
        }
        List reqVulnerabilities = Objects.requireNonNullElse(request.getVulnerabilities(), new ArrayList());
        boolean bl2 = hasChangedVulnerabilities = !componentVertex.getVulnerabilities().stream().map(VulnerabilityVertex::getVId).toList().equals(reqVulnerabilities);
        if (hasChangedVulnerabilities) {
            List vulnerabilityVertices = reqVulnerabilities.stream().map(arg_0 -> ((VulnerabilityDao)this.vulnerabilityDao).findByVId(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            componentVertex.setVulnerabilities(vulnerabilityVertices);
            vulnerabilityIndex.setRelease(ComponentSortHandler.computeVulnerabilitySortIndex(vulnerabilityVertices));
        }
        lock.lock();
        try {
            this.componentDao.withTransaction(session -> {
                componentVertex.recordEdit();
                this.updateCategory((ComponentVertex)componentVertex, request.getCategory(), session);
                this.updateComponent((ComponentVertex)componentVertex, request);
                if (hasChangedLicenses) {
                    componentVertex.setLicenseIndex(Integer.valueOf(licenseIndex.get()));
                    this.updateLicenses(componentVertex, session);
                    if (BooleanUtils.isTrue((Boolean)request.getUpdateFiles())) {
                        this.fileDao.findByComponent(componentVertex.getId(), session).forEach(f -> {
                            this.fileDao.unlinkAll((Vertex)f, (EClassDefinition)BOMClassDefinition.E.ELicense, session);
                            componentVertex.getLicenses().forEach(l -> this.fileDao.link((Vertex)f, (Vertex)l, (EClassDefinition)BOMClassDefinition.E.ELicense, session));
                        });
                    }
                }
                if (hasChangedVulnerabilities) {
                    componentVertex.setVulnerabilityIndex(Integer.valueOf(vulnerabilityIndex.get()));
                    this.updateVulnerabilities(componentVertex, session);
                }
                this.updateAndSaveComponent((ComponentVertex)componentVertex, session, !isLinkedComponent && !bomVertex.isCatalog());
                if (componentVertex.isContentEdited()) {
                    this.updateBomStatus(bomVertex, session);
                }
            });
            if (bomVertex.isCatalog() && !isLinkedComponent) {
                List linkedComponents = this.componentDao.findByLink(componentVertex.getId(), BOMClassDefinition.V.VComponent, BOMClassDefinition.E.EFrom);
                if (BooleanUtils.isTrue((Boolean)request.getUpdateLinked())) {
                    linkedComponents.forEach(c -> this.updateComponent(c.getId(), request, true));
                } else if (componentVertex.isContentEdited()) {
                    linkedComponents.forEach(c -> {
                        c.setSource(BomSource.LOCAL.name());
                        this.componentDao.save((Vertex)c);
                        this.componentDao.unlink((Vertex)c, (Vertex)componentVertex, (EClassDefinition)BOMClassDefinition.E.EFrom);
                    });
                }
            }
            if (hasChangedLicenses || hasChangedVulnerabilities || componentVertex.isContentEdited()) {
                this.kpiComputer.computeBasicKPIBackground(bomVertex, new EventListener[0]);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void recomputeFileCountForComponent(ComponentVertex componentVertex) {
        Optional reload;
        Long nbfiles = this.fileDao.countByComponent(componentVertex.getId());
        if (nbfiles > 0L && (reload = this.componentDao.findById(componentVertex.getId())).isPresent()) {
            ((ComponentVertex)reload.get()).setCountFiles(nbfiles);
            this.componentDao.save((Vertex)((ComponentVertex)reload.get()));
        }
    }

    private void internalMoveFiles(List<String> fileIds, ComponentVertex originalComponent, BomComponentVertex destComponent, ODatabaseSession session, boolean isNew) {
        List filesToMove = fileIds.stream().map(f -> (FileVertex)this.fileDao.findByIdWithLicense(RequestUtils.decodeId((String)f), session).orElseThrow(NoSuchElementException::new)).collect(Collectors.toList());
        ArrayList destFiles = isNew ? new ArrayList() : this.fileDao.findByComponent(destComponent.getId(), session);
        destFiles.addAll(filesToMove);
        destComponent.setPath(OperationHandler.recomputePath(destFiles));
        destComponent.setContentEdited();
        this.addFiles((ComponentVertex)destComponent, filesToMove, session);
        List fileLicenses = Stream.of(filesToMove.stream().map(FileVertex::getLicenses).flatMap(Collection::stream).collect(Collectors.toList()), destComponent.getLicenses()).flatMap(Collection::stream).filter(OperationHandler.distinct(LicenseVertex::getSpdxId)).collect(Collectors.toList());
        destComponent.setLicenses(fileLicenses);
        if (originalComponent.countFiles() - (long)filesToMove.size() <= 0L) {
            this.componentDao.delete((Vertex)originalComponent, session);
        } else {
            Collection originalFiles = this.fileDao.findByComponent(originalComponent.getId(), session);
            originalFiles.removeAll(filesToMove);
            originalComponent.setPath(OperationHandler.recomputePath((Collection)originalFiles));
            this.componentDao.save((Vertex)originalComponent, session);
            this.removeFiles(originalComponent, filesToMove, session);
        }
    }

    private void updateCategory(ComponentVertex vertex, String categoryReference, ODatabaseSession session) {
        String category = this.resolveCategory(categoryReference);
        this.componentDao.updateCategoryLink(vertex, category, session);
        vertex.setCategory(category);
        this.componentDao.save((Vertex)vertex, session);
    }

    private String resolveCategory(String categoryReference) {
        return Opt.ofBlankString((String)categoryReference).map(String::toUpperCase).map(DefaultCategory::valueOf).map(Enum::name).orElseThrow(IllegalArgumentException::new);
    }

    private void updateComponent(ComponentVertex vertex, FullUpdateRequest req) {
        Guards.notNull((Object)req);
        vertex.setName(Guards.notBlank((String)req.getName(), (Supplier)Suppliers.illegalArgument((String)"name is mandatory")));
        vertex.setDescription(Objects.requireNonNullElse(req.getDescription(), ""));
        vertex.setVersion(req.getVersion());
        vertex.setLastVersion(Objects.requireNonNullElse(req.getLatestVersion(), ""));
        vertex.setAllVersions((Map)Objects.requireNonNullElse(req.getAllVersions(), new HashMap()));
        vertex.setRepository(Objects.requireNonNullElse(req.getRepository(), ""));
        vertex.setReferences((List)Objects.requireNonNullElse(req.getReferences(), new ArrayList()));
        vertex.setTopics((List)Objects.requireNonNullElse(req.getTopics(), new ArrayList()));
        vertex.setLanguages((List)Objects.requireNonNullElse(req.getLanguages(), new ArrayList()));
        vertex.setComments(Objects.requireNonNullElse(req.getComments(), ""));
        vertex.setCopyright(Objects.requireNonNullElse(req.getCopyright(), ""));
        vertex.setUpToDate(ObsolescenceComputer.compute((String)vertex.getVersion(), (String)vertex.getLastVersion(), (Map)vertex.getAllVersions()).name());
    }

    private void updateLicenses(BomComponentVertex componentVertex, ODatabaseSession session) {
        this.componentDao.unlinkAll((Vertex)componentVertex, (EClassDefinition)BOMClassDefinition.E.ELicense, session);
        componentVertex.getLicenses().forEach(l -> this.componentDao.addLicense((ComponentVertex)componentVertex, l, session));
        componentVertex.setContentEdited();
    }

    private void updateVulnerabilities(BomComponentVertex componentVertex, ODatabaseSession session) {
        this.componentDao.unlinkAll((Vertex)componentVertex, (EClassDefinition)BOMClassDefinition.E.EVulnerability, session);
        componentVertex.getVulnerabilities().forEach(v -> this.componentDao.addVulnerability((ComponentVertex)componentVertex, v, session));
        componentVertex.setContentEdited();
    }

    private void updateFiles(ComponentVertex componentVertex, List<FileVertex> files, ODatabaseSession session) {
        this.componentDao.unlinkAll((Vertex)componentVertex, (EClassDefinition)BOMClassDefinition.E.EContains, session);
        componentVertex.setCountFiles(Long.valueOf(0L));
        this.addFiles(componentVertex, files, session);
    }

    private void addFiles(ComponentVertex componentVertex, List<FileVertex> files, ODatabaseSession session) {
        files.forEach(f -> this.componentDao.addFile(componentVertex, f, session));
        componentVertex.setCountFiles(Long.valueOf(componentVertex.countFiles() + (long)files.size()));
        componentVertex.setContentEdited();
    }

    private void addSnippets(ComponentVertex componentVertex, List<SnippetVertex> snippets, ODatabaseSession session) {
        snippets.forEach(s -> this.componentDao.addSnippet(componentVertex, s, session));
        componentVertex.setCountSnippets(Long.valueOf(componentVertex.countSnippets() + (long)snippets.size()));
        componentVertex.setContentEdited();
    }

    private void removeFiles(ComponentVertex componentVertex, List<FileVertex> files, ODatabaseSession session) {
        files.forEach(f -> this.componentDao.removeFile(componentVertex, f, session));
        componentVertex.setCountFiles(Long.valueOf(componentVertex.countFiles() - (long)files.size()));
        componentVertex.setContentEdited();
    }

    private void updateAndSaveComponent(ComponentVertex componentVertex, ODatabaseSession session, boolean updateSource) {
        if (componentVertex.isContentEdited() && updateSource) {
            componentVertex.setSource(BomSource.LOCAL.name());
            componentVertex.setModified(true);
        }
        this.componentDao.save((Vertex)componentVertex, session);
    }

    private void updateBomStatus(BomVertex bomVertex, ODatabaseSession session) {
        BomVertex bomToSave = (BomVertex)this.bomDao.findById(bomVertex.getId(), session).orElseThrow(IllegalStateException::new);
        bomToSave.setUpdated(Instant.now());
        this.bomDao.save((Vertex)bomToSave, session);
    }
}

